/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.provider;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.validator.provider.WrongTranslationMethodException;
import com.smartling.aem.connector.core.SmartlingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MachineTranslationMethodValidator.class})
public class MachineTranslationMethodValidator {
    public static final String DAM_ROOT_FOLDER = "/content/dam";
    public static final String CONTENT_ROOT_FOLDER = "/content";
    public static final String NO_CONFIG_ERROR_MESSAGE = "There is no Smartling config associated with the resource %s";
    @Reference
    private ServletUtils servletUtils;

    public void validate(String path, ResourceResolver resourceResolver) throws SmartlingException {
        MachineTranslationCloudConfig cloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, MachineTranslationCloudConfig.class);
        if (cloudConfig == null) {
            throw new SmartlingException(String.format(NO_CONFIG_ERROR_MESSAGE, path));
        }
        this.validateTranslationMethod(path, cloudConfig);
    }

    void validateTranslationMethod(String path, MachineTranslationCloudConfig machineTranslationCloudConfig) throws SmartlingException {
        if (StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)DAM_ROOT_FOLDER) ? machineTranslationCloudConfig.getDefaultTranslationProviderWorkflowForAssets() != MachineTranslationCloudConfig.TranslationProviderWorkflow.MACHINE_TRANSLATION : StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)CONTENT_ROOT_FOLDER) && machineTranslationCloudConfig.getDefaultTranslationProviderWorkflowForSites() != MachineTranslationCloudConfig.TranslationProviderWorkflow.MACHINE_TRANSLATION) {
            throw new WrongTranslationMethodException("Instant translation requires `Machine translation` translation method. Set proper method in Cloud Configuration");
        }
    }
}

