/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.update;

import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.ui.SmartlingValidationException;
import com.smartling.aem.connector.automation.ui.validator.update.UpdatesValidator;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UpdatesValidator.class})
public class UpdatesValidatorImpl
implements UpdatesValidator {
    public static final String ASSET_ROOT_FOLDER = "/content/dam";
    public static final String FORMS_ROOT_FOLDER = "/content/forms";
    public static final String CANNOT_START_TRANSLATION_NO_NEW_CONTENT = "Cannot start translation: no new content for paths=\"%s\". Please select \"Force resubmission (Required if page is unchanged)\" checkbox to start the translation anyway";
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;

    @Override
    public void validate(Resource resource, ResourceResolver resourceResolver, Set<String> targetLocaleCodes, boolean isDeep, Set<String> excludedPaths) throws SmartlingValidationException {
        if (StringUtils.startsWithIgnoreCase((CharSequence)resource.getPath(), (CharSequence)FORMS_ROOT_FOLDER)) {
            return;
        }
        boolean isAsset = StringUtils.startsWithIgnoreCase((CharSequence)resource.getPath(), (CharSequence)ASSET_ROOT_FOLDER);
        if (!isDeep || isAsset) {
            List<String> noUpdatesForPaths = this.getNoNewContentLanguageCopyPaths(resource.getPath(), resourceResolver, targetLocaleCodes);
            if (noUpdatesForPaths.size() == targetLocaleCodes.size()) {
                String paths = String.join((CharSequence)", ", noUpdatesForPaths);
                throw new SmartlingValidationException(String.format(CANNOT_START_TRANSLATION_NO_NEW_CONTENT, paths));
            }
        } else {
            List<String> subpagePaths = this.pageLanguageCopyManager.getSubpagesPaths(resourceResolver, resource.getPath(), excludedPaths);
            for (String subpagePath : subpagePaths) {
                List<String> noUpdatesForPaths = this.getNoNewContentLanguageCopyPaths(subpagePath, resourceResolver, targetLocaleCodes);
                if (noUpdatesForPaths.size() >= targetLocaleCodes.size()) continue;
                return;
            }
            throw new SmartlingValidationException(String.format(CANNOT_START_TRANSLATION_NO_NEW_CONTENT, String.format("All subpages paths for locales=\"%s\"", String.join((CharSequence)", ", targetLocaleCodes))));
        }
    }

    public List<String> getNoNewContentLanguageCopyPaths(String resourcePath, ResourceResolver resourceResolver, Set<String> targetLocaleCodes) {
        LanguageCopyManager languageCopyManager = StringUtils.startsWithIgnoreCase((CharSequence)resourcePath, (CharSequence)ASSET_ROOT_FOLDER) ? this.assetLanguageCopyManager : this.pageLanguageCopyManager;
        Date lastModifiedDate = languageCopyManager.getLastModified(resourceResolver, resourcePath);
        if (lastModifiedDate == null) {
            return Collections.emptyList();
        }
        Iterable<LanguageCopyManager.LanguageCopy> languageCopies = languageCopyManager.findLanguageCopies(resourceResolver, resourcePath);
        return StreamSupport.stream(languageCopies.spliterator(), false).filter(LanguageCopyManager.LanguageCopy::exists).filter(languageCopy -> targetLocaleCodes.contains(languageCopy.getLanguage().getCode())).filter(languageCopy -> languageCopy.getLastTranslationApplied() != null).filter(languageCopy -> lastModifiedDate.before(languageCopy.getLastTranslationApplied())).map(LanguageCopyManager.LanguageCopy::getPath).collect(Collectors.toList());
    }
}

