/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl;

import com.adobe.granite.comments.Comment;
import com.adobe.granite.comments.CommentCollection;
import com.adobe.granite.translation.api.TranslationConfig;
import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationObject;
import com.adobe.granite.translation.api.TranslationResult;
import com.adobe.granite.translation.api.TranslationScope;
import com.adobe.granite.translation.api.TranslationState;
import com.adobe.granite.translation.core.common.AbstractTranslationService;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.api.v2.client.exception.client.NotFoundErrorException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSmartlingTranslationService
extends AbstractTranslationService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSmartlingTranslationService.class);
    public static final String FAILED_TO_GET_OBJECT_LOG_MESSAGE_FORMAT = "Failed to get object: \"{}\"";
    private static final String TRANSLATION_MEMORY_NOT_SUPPORTED_MESSAGE = "Direct interaction with Translation Memory is not supported";
    private final SmartlingCloudConfig cloudConfig;

    public AbstractSmartlingTranslationService(@Nonnull SmartlingCloudConfig cloudConfig, TranslationConstants.TranslationMethod translationMethod, String name, String label, TranslationConfig config) {
        super(cloudConfig.getLanguageMapping(), Collections.emptyMap(), name, label, null, "/libs/settings/cloudconfigs/translation/smartling-translation", translationMethod, config);
        this.cloudConfig = cloudConfig;
    }

    protected Map<String, String> getAvailableLanguages() {
        return this.availableLanguageMap;
    }

    public TranslationResult translateString(String sourceString, String sourceLanguage, String targetLanguage, TranslationConstants.ContentType contentType, String contentCategory) throws TranslationException {
        logger.trace("In SmartlingTranslationService#translateString({}, {}, {}, {}, {})", new Object[]{sourceString, sourceLanguage, targetLanguage, contentType, contentCategory});
        throw new TranslationException("Synchronous translation is not supported", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public TranslationResult[] translateArray(String[] strings, String sourceLanguage, String targetLanguage, TranslationConstants.ContentType contentType, String contentCategory) throws TranslationException {
        logger.trace("In SmartlingTranslationService#translateArray([{}],...)", (Object)Arrays.toString(strings));
        throw new TranslationException("Synchronous translation is not supported", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public CommentCollection<Comment> getTranslationJobCommentCollection(String jobId) throws TranslationException {
        logger.trace("In SmartlingTranslationService#getTranslationJobCommentCollection({})", (Object)jobId);
        throw new TranslationException("Smartling does not support retrieving comments", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public void addTranslationJobComment(String jobId, Comment comment) throws TranslationException {
        logger.trace("In SmartlingTranslationService#addTranslationJobComment({},...)", (Object)jobId);
        throw new TranslationException("Smartling does not sending comments", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public CommentCollection<Comment> getTranslationObjectCommentCollection(String jobId, TranslationObject translationObject) throws TranslationException {
        logger.trace("In SmartlingTranslationService#getTranslationObjectCommentCollection({},...)", (Object)jobId);
        throw new TranslationException("Smartling does not support retrieving comments", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public void addTranslationObjectComment(String jobId, TranslationObject translationObject, Comment comment) throws TranslationException {
        logger.trace("In SmartlingTranslationService#addTranslationObjectComment({},...)", (Object)jobId);
        throw new TranslationException("Smartling does not support sending comments", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public TranslationConstants.TranslationStatus[] updateTranslationObjectsState(String jobId, TranslationObject[] translationObjects, TranslationState[] translationStates) throws TranslationException {
        throw new TranslationException("Smartling does not support bulk operations", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public TranslationConstants.TranslationStatus[] getTranslationObjectsStatus(String jobId, TranslationObject[] translationObjects) throws TranslationException {
        throw new TranslationException("Smartling does not support bulk operations", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public TranslationResult[] getAllStoredTranslations(String sourceString, String sourceLanguage, String targetLanguage, TranslationConstants.ContentType contentType, String contentCategory, String userId, int maxTranslations) throws TranslationException {
        logger.trace("In SmartlingTranslationService#getAllStoredTranslations(...)");
        throw new TranslationException(TRANSLATION_MEMORY_NOT_SUPPORTED_MESSAGE, TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public void storeTranslation(String originalText, String sourceLanguage, String targetLanguage, String updatedTranslation, TranslationConstants.ContentType contentType, String contentCategory, String userId, int rating, String path) throws TranslationException {
        logger.trace("In SmartlingTranslationService#storeTranslation(...)");
        throw new TranslationException(TRANSLATION_MEMORY_NOT_SUPPORTED_MESSAGE, TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public void storeTranslation(String[] originalText, String sourceLanguage, String targetLanguage, String[] updatedTranslation, TranslationConstants.ContentType contentType, String contentCategory, String userId, int rating, String path) throws TranslationException {
        logger.trace("In SmartlingTranslationService#storeTranslation(...)");
        throw new TranslationException(TRANSLATION_MEMORY_NOT_SUPPORTED_MESSAGE, TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public Map<String, String> supportedLanguages() {
        logger.trace("In SmartlingTranslationService#supportedLanguages()");
        return Collections.unmodifiableMap(this.getAvailableLanguages());
    }

    public boolean isDirectionSupported(String sourceLanguage, String targetLanguage) throws TranslationException {
        logger.trace("In SmartlingTranslationService#isDirectionSupported({}, {})", (Object)sourceLanguage, (Object)targetLanguage);
        try {
            return this.cloudConfig.isDirectionSupported(sourceLanguage, targetLanguage);
        }
        catch (SmartlingException e) {
            logger.error("Failed to check if direction of translation supported sourceLanguage=\"{}\" targetLanguage=\"{}\":", new Object[]{sourceLanguage, targetLanguage, e});
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    public String detectLanguage(String detectSource, TranslationConstants.ContentType contentType) throws TranslationException {
        logger.trace("In SmartlingTranslationService#detectLanguage({}, {})", (Object)detectSource, (Object)contentType);
        throw new TranslationException("Smartling does not support language detection", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public TranslationScope getFinalScope(String jobId) {
        logger.trace("In SmartlingTranslationService#getFinalScope({})", (Object)jobId);
        logger.warn("Scoping is not supported by Smartling. Empty result will be returned.");
        return new DummyTranslationScope();
    }

    protected String mapToSmartlingLocaleCode(String localeCode) throws TranslationException {
        String smartlingSourceLanguageCode = this.getAvailableLanguages().get(localeCode);
        if (smartlingSourceLanguageCode == null) {
            throw new TranslationException("Locale " + localeCode + " is not supported", TranslationException.ErrorCode.NOT_SUPPORTED_LANG_DIRECTION);
        }
        return smartlingSourceLanguageCode;
    }

    protected static boolean isInTerminalState(TranslationObject translationObject) {
        TranslationConstants.TranslationStatus status = translationObject.getTranslationJobMetadata().getTranslationState().getStatus();
        return status == TranslationConstants.TranslationStatus.CANCEL || status == TranslationConstants.TranslationStatus.APPROVED || status == TranslationConstants.TranslationStatus.REJECTED;
    }

    protected static boolean wasUploaded(TranslationObject translationObject) {
        return translationObject.getId() != null;
    }

    protected static TranslationConstants.TranslationStatus toTranslationStatus(SmartlingFacade.Status status) {
        if (status == SmartlingFacade.Status.NOT_AUTHORIZED) {
            return TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION;
        }
        if (status == SmartlingFacade.Status.IN_PROGRESS) {
            return TranslationConstants.TranslationStatus.TRANSLATION_IN_PROGRESS;
        }
        return TranslationConstants.TranslationStatus.TRANSLATED;
    }

    protected static boolean logNoFoundException(SmartlingException caught) {
        if (caught.getCause() != null && caught.getCause() instanceof NotFoundErrorException) {
            NotFoundErrorException apiException = (NotFoundErrorException)caught.getCause();
            logger.error(FAILED_TO_GET_OBJECT_LOG_MESSAGE_FORMAT, (Object)apiException.getMessage());
            return true;
        }
        return false;
    }

    protected static boolean isPathForDita(String path) {
        return StringUtils.endsWithIgnoreCase((CharSequence)path, (CharSequence)".dita") || StringUtils.endsWithIgnoreCase((CharSequence)path, (CharSequence)".ditamap");
    }

    public static class DummyTranslationScope
    implements TranslationScope {
        public int getWordCount() {
            return 0;
        }

        public int getImageCount() {
            return 0;
        }

        public int getVideoCount() {
            return 0;
        }

        public Map<String, String> getFinalScope() {
            return Collections.emptyMap();
        }
    }
}

