/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClientFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSmartlingCloudConfig
implements SmartlingCloudConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSmartlingCloudConfig.class);
    private static final String GLOBAL_MAPPING_PATH = "granite/translation/connector/config/smartling/languageMapping";
    private static final String MOVED_GLOBAL_MAPPING_PATH = "granite/translation/connector/configuration/smartling/languageMapping";
    private final ProjectApiClientFactory projectApiClientFactory;
    protected final Map<String, String> languageMapping;
    protected final Map<String, Set<String>> inverseLanguageMapping;

    BaseSmartlingCloudConfig(ProjectApiClientFactory projectApiClientFactory, ResourceResolver resourceResolver) {
        this.projectApiClientFactory = projectApiClientFactory;
        Resource mappingRoot = resourceResolver.getResource(GLOBAL_MAPPING_PATH);
        if (mappingRoot == null) {
            LOGGER.trace("Couldn't locale \"{}\" for locale mappings. Tying to locate \"{}\"", (Object)GLOBAL_MAPPING_PATH, (Object)MOVED_GLOBAL_MAPPING_PATH);
            mappingRoot = resourceResolver.getResource(MOVED_GLOBAL_MAPPING_PATH);
        }
        this.languageMapping = BaseSmartlingCloudConfig.loadLanguageMapping(mappingRoot);
        this.inverseLanguageMapping = BaseSmartlingCloudConfig.reverse(this.languageMapping);
    }

    @Override
    public Map<String, String> getLanguageMapping() {
        return this.languageMapping;
    }

    @Override
    public Set<String> mapSmartlingCodeToLocale(String smartlingLocaleCode) {
        Set<String> result = this.inverseLanguageMapping.get(smartlingLocaleCode);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public boolean isDirectionSupported(String sourceLanguage, String targetLanguage) throws SmartlingException {
        return this.isDirectionSupported(this, sourceLanguage, targetLanguage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isDirectionSupported(SmartlingCloudConfig config, String sourceLanguage, String targetLanguage) {
        String sourceSmartlingLocaleCode = this.getLanguageMapping().get(sourceLanguage);
        if (sourceSmartlingLocaleCode == null) {
            LOGGER.warn("Can not resolve Smartling source locale from language mapping. No mapping for {} is present", (Object)sourceLanguage);
            return false;
        }
        String targetSmartlingLocaleCode = this.getLanguageMapping().get(targetLanguage);
        if (targetSmartlingLocaleCode == null) {
            LOGGER.warn("Can not resolve Smartling target locale from language mapping. No mapping for {} is present", (Object)targetLanguage);
            return false;
        }
        try (ProjectApiClient projectApiClient = this.projectApiClientFactory.createClient(config);){
            boolean languageSupported = projectApiClient.isLanguageSupported(targetSmartlingLocaleCode);
            if (!languageSupported) {
                LOGGER.warn("Target locale {} is not supported for project {}", (Object)targetSmartlingLocaleCode, (Object)config.getProjectId());
            }
            boolean bl = languageSupported;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("General error on check if \"{}\" locale is supported by Smartling project", (Object)targetSmartlingLocaleCode, (Object)e);
            return false;
        }
    }

    private static Map<String, String> loadLanguageMapping(Resource mappingRoot) {
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (mappingRoot != null) {
            for (Resource entry : mappingRoot.getChildren()) {
                result.put(entry.getName(), (String)entry.getValueMap().get("languageMapping", (Object)""));
            }
        } else {
            LOGGER.error("Couldn't load locale mappings");
        }
        return result;
    }

    private static Map<String, Set<String>> reverse(Map<String, String> mapping) {
        TreeMap<String, Set<String>> result = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            String value = entry.getValue();
            Set<String> set = result.containsKey(value) ? (Set)result.get(value) : new TreeSet(String.CASE_INSENSITIVE_ORDER);
            set.add(entry.getKey());
            result.put(value, set);
        }
        return result;
    }
}

