/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import com.smartling.aem.connector.core.NetworkSettings;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={NetworkSettings.class})
@Designate(ocd=Config.class)
public class NetworkConfiguration
implements NetworkSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkConfiguration.class);
    private boolean proxyEnabled;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;

    @Activate
    protected void activate(Config config) {
        this.proxyHost = NetworkConfiguration.getStringValueOrNull(config.proxy_host());
        this.proxyPort = null;
        try {
            this.proxyPort = config.proxy_port() == 0 ? null : Integer.valueOf(config.proxy_port());
        }
        catch (Exception e) {
            LOGGER.error("Error while setting proxy port. Default value 'null' was applied", (Throwable)e);
        }
        this.proxyUser = NetworkConfiguration.getStringValueOrNull(config.proxy_user());
        this.proxyPassword = NetworkConfiguration.getStringValueOrNull(config.proxy_password());
        boolean bl = this.proxyEnabled = config.proxy_enabled() && this.proxyHost != null && this.proxyPort != null;
        if (this.proxyEnabled) {
            if (this.proxyUser == null) {
                LOGGER.info("Using anonymous proxy {}:{}", (Object)this.proxyHost, (Object)this.proxyPort);
            } else {
                LOGGER.info("Using proxy {}:{}, authenticating as {}/******", new Object[]{this.proxyHost, this.proxyPort, this.proxyUser});
            }
        } else {
            LOGGER.info("Proxy is disabled or configuration incomplete");
        }
    }

    private static String getStringValueOrNull(String value) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)value, null);
    }

    @Override
    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public String getProxyUser() {
        return this.proxyUser;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    public boolean requireProxyAuthentication() {
        return this.getProxyUser() != null && this.getProxyPassword() != null;
    }

    @ObjectClassDefinition(name="Smartling - Network Settings (Touch)", description="Network configuration for Smartling Connector")
    public static @interface Config {
        @AttributeDefinition(name="Enable Proxy", description="Whether to enable or disable this particular proxy configuration. The default value is false.")
        public boolean proxy_enabled() default false;

        @AttributeDefinition(name="Proxy Host", description="Host name (or IP Address) of the HTTP Proxy. This property is ignored if this proxy configuration is disabled. This property does not have a default value.")
        public String proxy_host() default "";

        @AttributeDefinition(name="Proxy Port", description="TCP port of the HTTP Proxy. This property is ignored if this proxy configuration is disabled. This property does not have a default value")
        public int proxy_port() default 0;

        @AttributeDefinition(name="Proxy User", description="The name of the user to authenticate as with the HTTP Proxy Host. If this field is empty, the proxy is considered to not be authenticated. The default is empty.")
        public String proxy_user() default "";

        @AttributeDefinition(name="Proxy Password", description="The password of the HTTP Proxy user to authenticate with. The default is empty.")
        public String proxy_password() default "";
    }
}

