/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import com.adobe.granite.license.ProductInfo;
import com.adobe.granite.license.ProductInfoProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ProjectMetadata.class})
public class ProjectMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectMetadata.class);
    private static final String PROJECT_PROPERTIES_FILE = "project.properties";
    private static final String PROJECT_VERSION = "version";
    private static final String CLIENT_PROPERTY_NAME = "client";
    @Reference
    private ProductInfoProvider productInfoProvider;

    public String getName() {
        return PropertiesHolder.PROPERTIES.getProperty(CLIENT_PROPERTY_NAME);
    }

    public String getVersion() {
        return this.getProjectVersion() + " " + this.getAemVersion() + " " + this.getJavaVersion();
    }

    private String getProjectVersion() {
        return PropertiesHolder.PROPERTIES.getProperty(PROJECT_VERSION);
    }

    private String getAemVersion() {
        ProductInfo productInfo = this.productInfoProvider.getProductInfo();
        return productInfo.getShortName() + "/" + productInfo.getVersion().toString();
    }

    private String getJavaVersion() {
        return "Java/" + System.getProperty("java.version");
    }

    private static class PropertiesHolder {
        private static Properties PROPERTIES = new Properties();

        private PropertiesHolder() {
        }

        static {
            try (InputStream resourceAsStream = PropertiesHolder.class.getClassLoader().getResourceAsStream(ProjectMetadata.PROJECT_PROPERTIES_FILE);){
                PROPERTIES.load(resourceAsStream);
            }
            catch (IOException e) {
                LOGGER.error("Could not find properties file {}", (Object)ProjectMetadata.PROJECT_PROPERTIES_FILE);
                throw new IllegalStateException("Could not load connector metadata", e);
            }
        }
    }
}

