/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.instant;

import com.adobe.granite.translation.api.TranslationConfig;
import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationMetadata;
import com.adobe.granite.translation.api.TranslationObject;
import com.adobe.granite.translation.api.TranslationResult;
import com.adobe.granite.translation.api.TranslationScope;
import com.adobe.granite.translation.api.TranslationService;
import com.adobe.granite.translation.api.TranslationState;
import com.adobe.granite.translation.core.common.TranslationResultImpl;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingException;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationDetailsManager;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.AbstractSmartlingTranslationService;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.aem.connector.core.impl.TranslationObjectToResourceAdapter;
import com.smartling.aem.connector.core.impl.instant.InstantSmartlingFacade;
import com.smartling.aem.connector.core.impl.integration.NoTranslatableContentException;
import com.smartling.aem.connector.core.impl.integration.NotSupportedFormatException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmartlingInstantTranslationService
extends AbstractSmartlingTranslationService
implements TranslationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingInstantTranslationService.class);
    private final SmartlingCloudConfig cloudConfig;
    private final InstantSmartlingFacade facade;
    private final TranslationDetailsManager translationDetailsManager;

    SmartlingInstantTranslationService(@Nonnull SmartlingCloudConfig cloudConfig, String name, String label, TranslationConfig config, InstantSmartlingFacade facade, TranslationDetailsManager translationDetailsManager) {
        super(cloudConfig, TranslationConstants.TranslationMethod.MACHINE_TRANSLATION, name, label, config);
        this.cloudConfig = cloudConfig;
        this.facade = facade;
        this.translationDetailsManager = translationDetailsManager;
    }

    @Override
    public TranslationResult translateString(String sourceString, String sourceLanguage, String targetLanguage, TranslationConstants.ContentType contentType, String contentCategory) throws TranslationException {
        LOGGER.trace("In SmartlingInstantTranslationService#translateString({}, {}, {}, {}, {})", new Object[]{sourceString, sourceLanguage, targetLanguage, contentType, contentCategory});
        TranslationResult[] result = this.translateArray(new String[]{sourceString}, sourceLanguage, targetLanguage, contentType, contentCategory);
        return result[0];
    }

    @Override
    public TranslationResult[] translateArray(String[] strings, String sourceLanguage, String targetLanguage, TranslationConstants.ContentType contentType, String contentCategory) throws TranslationException {
        LOGGER.trace("In SmartlingInstantTranslationService#translateArray([{}],...)", (Object)Arrays.toString(strings));
        try {
            String[] translated = this.facade.translateArray(this.cloudConfig, strings, sourceLanguage, targetLanguage);
            if (translated.length != strings.length) {
                String errorMessage = "Failed to translate strings=\"" + Arrays.toString(strings) + "\" sourceLanguage=\"" + sourceLanguage + "\" targetLanguage=\"" + targetLanguage + "\". Source strings count=\"" + strings.length + "\", translation strings count=\"" + translated.length + "\"";
                LOGGER.error(errorMessage);
                throw new TranslationException(errorMessage, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            ArrayList<TranslationResultImpl> result = new ArrayList<TranslationResultImpl>();
            int length = translated.length;
            for (int i = 0; i < length; ++i) {
                result.add(new TranslationResultImpl(translated[i], sourceLanguage, targetLanguage, contentType, contentCategory, strings[i], 0, null));
            }
            return result.toArray(new TranslationResult[0]);
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed translate strings=\"{}\" sourceLanguage=\"{}\" targetLanguage=\"{}\":", new Object[]{Arrays.toString(strings), sourceLanguage, targetLanguage, e});
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    public String createTranslationJob(String name, String description, String sourceLanguage, String targetLanguage, Date dueDate, TranslationState state, TranslationMetadata jobMetadata) throws TranslationException {
        LOGGER.trace("In SmartlingInstantTranslationService#createTranslationJob({}, .., {}, {}, ..)", new Object[]{name, sourceLanguage, targetLanguage});
        String smartlingSourceLanguageCode = this.mapToSmartlingLocaleCode(sourceLanguage);
        String smartlingTargetLanguageCode = this.mapToSmartlingLocaleCode(targetLanguage);
        try {
            return this.facade.createTranslationJob(smartlingSourceLanguageCode, smartlingTargetLanguageCode);
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed to create translation job jobName=\"{}\" sourceLanguage=\"{}\" targetLanguage=\"{}\":", new Object[]{name, sourceLanguage, targetLanguage, e});
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    public void updateTranslationJobMetadata(String jobId, TranslationMetadata jobMetadata, TranslationConstants.TranslationMethod translationMethod) {
        LOGGER.trace("In SmartlingInstantTranslationService#updateTranslationJobMetadata({},...)", (Object)jobId);
        LOGGER.warn("Could not update translation Job metadata: feature is not implemented.");
    }

    public String uploadTranslationObject(String jobId, TranslationObject translationObject) throws TranslationException {
        LOGGER.trace("In SmartlingInstantTranslationService#uploadTranslationObject({}, \"{}\"[{}])", new Object[]{jobId, translationObject.getTitle(), translationObject.getTranslationObjectSourcePath()});
        try {
            String translationObjectFileType = this.translationDetailsManager.getTranslationObjectDetails(jobId, translationObject.getTranslationObjectSourcePath()).getTranslationObjectFileType();
            TranslationObjectToResourceAdapter resource = new TranslationObjectToResourceAdapter(translationObject, translationObject.getTranslationObjectInputStream(), SmartlingFacade.Type.XML, translationObjectFileType);
            return this.facade.uploadFile(this.cloudConfig, jobId, resource);
        }
        catch (NotSupportedFormatException e) {
            LOGGER.info("Skipped file objectTitle=\"{}\" objectPath=\"{}\" jobId=\"{}\": due message=\"{}\"", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e.getMessage()});
            return null;
        }
        catch (NoTranslatableContentException e) {
            LOGGER.info("Failed to upload file objectTitle=\"{}\" objectPath=\"{}\" jobId=\"{}\", no source strings found. \"{}\"", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e.getMessage()});
            return null;
        }
        catch (PropertyMappingException e) {
            LOGGER.error("Failed to apply Smartling property mappings for file objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\"", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
            throw new TranslationException("Failed to apply Smartling property mappings", (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed to upload translation object objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't upload translation object objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    @Override
    public TranslationScope getFinalScope(String jobId) {
        LOGGER.trace("In SmartlingInstantTranslationService#getFinalScope({})", (Object)jobId);
        LOGGER.warn("Scoping is not supported by Smartling. Empty result will be returned.");
        return new AbstractSmartlingTranslationService.DummyTranslationScope();
    }

    public TranslationConstants.TranslationStatus updateTranslationJobState(String jobId, TranslationState state) throws TranslationException {
        LOGGER.trace("In SmartlingInstantTranslationService#updateTranslationJobState({}, {})", (Object)jobId, (Object)state.getStatus());
        return state.getStatus();
    }

    public TranslationConstants.TranslationStatus getTranslationJobStatus(String jobId) throws TranslationException {
        LOGGER.trace("In SmartlingInstantTranslationService#getTranslationJobStatus({})", (Object)jobId);
        return TranslationConstants.TranslationStatus.TRANSLATED;
    }

    public InputStream getTranslatedObject(String jobId, TranslationObject translationObject) throws TranslationException {
        LOGGER.trace("In SmartlingInstantTranslationService#getTranslatedObject(..., {})", (Object)translationObject.getId());
        try {
            return this.facade.getTranslatedFile(this.cloudConfig, jobId, translationObject.getId());
        }
        catch (SmartlingException e) {
            if (!SmartlingInstantTranslationService.logNoFoundException(e)) {
                LOGGER.error("Failed to get translated content objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
            }
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't get translated content objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    public TranslationConstants.TranslationStatus updateTranslationObjectState(String jobId, TranslationObject translationObject, TranslationState translationState) throws TranslationException {
        LOGGER.trace("In SmartlingInstantTranslationService#updateTranslationObjectState(..., {}, {})", (Object)translationObject.getId(), (Object)translationState.getStatus());
        if (translationState.getStatus() == TranslationConstants.TranslationStatus.CANCEL) {
            if (SmartlingInstantTranslationService.wasUploaded(translationObject)) {
                try {
                    this.facade.deleteFile(this.cloudConfig, jobId, translationObject.getId());
                }
                catch (SmartlingException e) {
                    if (!SmartlingInstantTranslationService.logNoFoundException(e)) {
                        LOGGER.error("Failed to delete file objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
                    }
                    throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
                }
                catch (Exception e) {
                    LOGGER.error("Couldn't delete file objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
                    throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
                }
            } else {
                LOGGER.debug("Translation Object objectPath=\"{}\", jobId=\"{}\" has never been sent for translation. No need to cancel it.", (Object)translationObject.getTranslationObjectSourcePath(), (Object)jobId);
            }
        }
        return translationState.getStatus();
    }

    public TranslationConstants.TranslationStatus getTranslationObjectStatus(String jobId, TranslationObject translationObject) throws TranslationException {
        LOGGER.trace("In SmartlingInstantTranslationService#getTranslationObjectStatus(..., {})", (Object)translationObject.getId());
        if (SmartlingInstantTranslationService.isInTerminalState(translationObject)) {
            TranslationConstants.TranslationStatus currentStatus = translationObject.getTranslationJobMetadata().getTranslationState().getStatus();
            LOGGER.info("Translation object objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\" is already in {} state. Nothing to do.", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, currentStatus});
            return currentStatus;
        }
        if (SmartlingInstantTranslationService.wasUploaded(translationObject)) {
            try {
                SmartlingFacade.Status status = this.facade.getObjectStatus(this.cloudConfig, jobId, translationObject.getId());
                return SmartlingInstantTranslationService.toTranslationStatus(status);
            }
            catch (SmartlingException e) {
                if (!SmartlingInstantTranslationService.logNoFoundException(e)) {
                    LOGGER.error("Failed to get translation object status objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
                }
                throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            catch (Exception e) {
                LOGGER.error("Couldn't get translation object status objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
                throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
        }
        LOGGER.info("Translation object objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\": has never been sent for translation. Marking it as Ready for Review.", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId});
        return TranslationConstants.TranslationStatus.READY_FOR_REVIEW;
    }
}

