/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration;

import com.adobe.cq.wcm.launches.utils.LaunchUtils;
import com.day.cq.commons.Language;
import com.day.cq.wcm.api.LanguageManager;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.aem.connector.core.impl.integration.ResourceNamespaceResolver;
import com.smartling.aem.connector.core.impl.integration.TranslationUploadRequest;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ResourceNamespaceResolver.class})
public class LaunchAwareNamespaceResolver
implements ResourceNamespaceResolver {
    public static final String EXPERIENCE_FRAGMENTS_START_PATH = "/content/experience-fragments/";
    public static final String CONTENTFRAGMENT_TRANSLATION_OBJECT_FILE_TYPE = "CONTENTFRAGMENT";
    public static final String DAM_ASSET_TRANSLATION_OBJECT_FILE_TYPE = "ASSET";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private LanguageManager languageManager;

    @Override
    public String resolveNamespace(TranslationUploadRequest request, boolean shouldShareStrings, boolean shouldUseUniqueStrings) throws SmartlingException {
        SmartlingFacade.Resource resource = request.getResource();
        if (shouldUseUniqueStrings && (LaunchAwareNamespaceResolver.isDamAsset(resource) || LaunchAwareNamespaceResolver.isContentFragment(resource) || LaunchAwareNamespaceResolver.isExperienceFragment(resource))) {
            return request.getFileUri();
        }
        Optional<String> path = resource.getPath();
        String baseNamespacePath = path.isPresent() ? this.resolvePath(path.get(), request.getAemSourceLocaleCode()) : resource.getTitle();
        return shouldShareStrings ? baseNamespacePath : baseNamespacePath + "-" + request.getSmartlingTargetLocaleCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolvePath(String path, String aemSourceLanguageCode) throws SmartlingException {
        String string;
        ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());
        try {
            String targetPath = this.tryFindLaunchTargetPath(resolver, path);
            Optional<String> sourcePathIfExist = this.getSourcePathIfExist(resolver, targetPath, aemSourceLanguageCode);
            string = sourcePathIfExist.orElse(targetPath);
        }
        catch (Throwable throwable) {
            try {
                resolver.close();
                throw throwable;
            }
            catch (LoginException e) {
                throw new SmartlingException("Internal connector error: could not build namespace for a file", e);
            }
        }
        resolver.close();
        return string;
    }

    private String tryFindLaunchTargetPath(ResourceResolver resolver, String path) {
        Resource pathResource = resolver.getResource(path);
        if (pathResource != null) {
            if ("dam:Asset".equals(pathResource.getResourceType())) {
                return this.getDamAssetTargetResourcePath(pathResource);
            }
            return LaunchUtils.getTargetResourcePath((Resource)pathResource, null);
        }
        return path;
    }

    private Optional<String> getSourcePathIfExist(ResourceResolver resolver, String path, String aemSourceLanguageCode) {
        Map<Language, LanguageManager.Info> languageVersions = this.getLanguageVersions(resolver, path);
        return languageVersions.entrySet().stream().filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)aemSourceLanguageCode, (CharSequence)((Language)entry.getKey()).toString().toLowerCase())).map(entry -> ((LanguageManager.Info)entry.getValue()).getPath()).findFirst();
    }

    private Map<Language, LanguageManager.Info> getLanguageVersions(ResourceResolver resolver, String path) {
        Map<Language, LanguageManager.Info> languageInfo = this.languageManager.getAdjacentLanguageInfo(resolver, path);
        return languageInfo != null ? languageInfo : Collections.emptyMap();
    }

    private String getDamAssetTargetResourcePath(Resource pathResource) {
        ValueMap content = pathResource.getChild("jcr:content").getValueMap();
        return (String)content.get("dam:destinationLanguageCopy", (Object)pathResource.getPath());
    }

    private static boolean isExperienceFragment(SmartlingFacade.Resource resource) {
        return resource.getPath().isPresent() && StringUtils.containsIgnoreCase((CharSequence)resource.getPath().get(), (CharSequence)EXPERIENCE_FRAGMENTS_START_PATH);
    }

    private static boolean isContentFragment(SmartlingFacade.Resource resource) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)resource.getTranslationObjectFileType(), (CharSequence[])new CharSequence[]{CONTENTFRAGMENT_TRANSLATION_OBJECT_FILE_TYPE});
    }

    private static boolean isDamAsset(SmartlingFacade.Resource resource) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)resource.getTranslationObjectFileType(), (CharSequence[])new CharSequence[]{DAM_ASSET_TRANSLATION_OBJECT_FILE_TYPE});
    }
}

