/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform.jobs;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class JobUtil {
    public static final int MAX_JOB_NAME_LENGTH = 170;
    public static final Pattern CANCELLED_JOB_NAME_PATTERN = Pattern.compile("(.+)(\\s\\(Cancelled[^\\)]+\\))+?");

    public static String generateJobName(String title) {
        String fullJobName = new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + " - " + title + " - " + System.nanoTime();
        return StringUtils.abbreviateMiddle((String)fullJobName, (String)"...", (int)170);
    }

    public static String enrichJobNameWithSuffix(String jobName) {
        Matcher matcher = CANCELLED_JOB_NAME_PATTERN.matcher(jobName);
        String fullJobName = null;
        fullJobName = matcher.matches() && matcher.groupCount() > 1 ? matcher.group(1) + " - " + System.nanoTime() : jobName + " - " + System.nanoTime();
        return StringUtils.abbreviateMiddle((String)fullJobName, (String)"...", (int)170);
    }
}

