/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.connection;

import com.smartling.aem.connector.automation.CloudConfigLocator;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.context.ContextConnectionManager;
import com.smartling.aem.connector.context.impl.resources.ResourceLoader;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingConnectionException;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingCredentialsException;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingException;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingLoginException;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/context/connection/check"})
public class ContextConnectionCheckServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextConnectionCheckServlet.class);
    static final String CONFIG_PATH_PARAMETER = "configPath";
    static final String ERROR_DURING_CHECKING_GATEWAY_CONNECTION = "Error during checking gateway connection";
    static final String ERROR_DURING_CHECKING_RESOURCE_LOADER_LOGIN = "Error during checking resource loader login";
    public static final String WRONG_CREDENTIALS_MESSAGE = "Couldn't authenticate AEM credentials for Smartling context. Check User and Password in \"Smartling - Context Preview Settings (Touch)\" configuration (web console).";
    public static final String WRONG_CONTEXT_URL_MESSAGE = "Couldn't connect to AEM for testing Smartling context. Check Server URL in \"Smartling - Context Preview Settings (Touch)\" configuration (web console).";
    public static final String NO_URL_AND_CREDENTIALS_MESSAGE = "Smartling context is not configured. Please complete configuration in \"Smartling - Context Preview Settings (Touch)\" (web console).";
    @Reference
    private ServletUtils servletUtils;
    @Reference
    private ContextConnectionManager contextConnectionManager;
    @Reference
    private ResourceLoader resourceLoader;
    @Reference
    private CloudConfigLocator cloudConfigLocator;

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        SmartlingCloudConfig cloudConfig = null;
        try {
            String configPath = request.getParameter(CONFIG_PATH_PARAMETER);
            cloudConfig = (SmartlingCloudConfig)this.cloudConfigLocator.getCloudConfig(configPath, SmartlingCloudConfig.class);
            if (cloudConfig == null) {
                String errorMessage = String.format("Error during checking connection for smartling project, cloudConfig is abscent for config path %s", configPath);
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, errorMessage);
                LOGGER.warn(errorMessage);
            }
            if (!this.contextConnectionManager.initializeContextForConfig(cloudConfig).get(3L, TimeUnit.SECONDS).booleanValue()) {
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, ERROR_DURING_CHECKING_GATEWAY_CONNECTION);
                LOGGER.warn("Error during checking gateway connection {}: ", (Object)cloudConfig.getProjectId());
            }
            this.resourceLoader.loadResource("/");
        }
        catch (ResourceLoadingConnectionException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, WRONG_CONTEXT_URL_MESSAGE);
            LOGGER.warn("Couldn't connect to AEM for testing Smartling context. Check Server URL in \"Smartling - Context Preview Settings (Touch)\" configuration (web console). {}: ", (Object)cloudConfig.getProjectId(), (Object)e);
        }
        catch (ResourceLoadingCredentialsException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, NO_URL_AND_CREDENTIALS_MESSAGE);
            LOGGER.warn("Smartling context is not configured. Please complete configuration in \"Smartling - Context Preview Settings (Touch)\" (web console). {}: ", (Object)cloudConfig.getProjectId(), (Object)e);
        }
        catch (ResourceLoadingLoginException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, WRONG_CREDENTIALS_MESSAGE);
            LOGGER.warn("Couldn't authenticate AEM credentials for Smartling context. Check User and Password in \"Smartling - Context Preview Settings (Touch)\" configuration (web console). {}: ", (Object)cloudConfig.getProjectId(), (Object)e);
        }
        catch (ResourceLoadingException e) {
            String errorMessage = e.getMessage();
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, errorMessage);
            LOGGER.warn("Error during checking resource loader login {}: ", (Object)cloudConfig.getProjectId(), (Object)e);
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, errorMessage);
            LOGGER.warn("Error during checking gateway connection {}: ", (Object)cloudConfig.getProjectId(), (Object)e);
        }
    }
}

