/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.connection;

import com.smartling.aem.connector.context.ContextConnection;
import com.smartling.aem.connector.context.impl.ConnectionSettings;
import com.smartling.aem.connector.context.impl.connection.ClientProducer;
import com.smartling.aem.connector.context.impl.connection.ContextGatewayConnection;
import com.smartling.aem.connector.context.impl.connection.GatewayClientFactory;
import com.smartling.aem.connector.context.impl.connection.ResourceLoadingHandlerImpl;
import com.smartling.aem.connector.context.impl.resources.ResourceLoader;
import com.smartling.aem.connector.core.FileUriResolver;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={GatewayConnectionFactory.class})
@Designate(ocd=Config.class)
public class GatewayConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayConnectionFactory.class);
    private static final int DEFAULT_POOL_SIZE = 5;
    @Reference
    private ResourceLoader resourcesFacade;
    @Reference
    private GatewayClientFactory clientFactory;
    @Reference
    private FileUriResolver fileUriResolver;
    private Executor executor;

    @Activate
    protected void activate(Config config) {
        int poolSize = 5;
        try {
            poolSize = config.pool_size();
        }
        catch (Exception e) {
            LOGGER.error("Error while setting pool size. Default value '{}' was applied", (Object)5, (Object)e);
        }
        this.executor = GatewayConnectionFactory.createThreadPool(poolSize);
    }

    private static Executor createThreadPool(int maximumPoolSize) {
        ThreadFactory threadFactory = GatewayConnectionFactory.namedThreadFactory();
        return new ThreadPoolExecutor(0, maximumPoolSize, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public ContextConnection createConnection(ConnectionSettings settings) {
        ClientProducer clientProducer = new ClientProducer(settings, this.clientFactory, this.executor);
        ResourceLoadingHandlerImpl loadingHandler = new ResourceLoadingHandlerImpl(this.resourcesFacade, this.fileUriResolver);
        return new ContextGatewayConnection(clientProducer, loadingHandler);
    }

    private static ThreadFactory namedThreadFactory() {
        final ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
        final AtomicLong count = new AtomicLong(0L);
        return new ThreadFactory(){

            @Override
            public Thread newThread(@NotNull Runnable runnable) {
                Thread thread = backingThreadFactory.newThread(runnable);
                thread.setName(String.format("context-loader-%d", count.getAndIncrement()));
                return thread;
            }
        };
    }

    @ObjectClassDefinition(name="Smartling - Context Advanced Settings (Touch)", description="Various settings, affecting context capturing details and performance")
    public static @interface Config {
        @AttributeDefinition(name="Pool Size", description="Number of parallel threads used to capture context")
        public int pool_size() default 5;
    }
}

