/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.resources.render;

import com.smartling.aem.connector.context.impl.resources.ResourceLoadingException;
import com.smartling.aem.connector.context.impl.resources.http.HttpResourceLoader;
import com.smartling.aem.connector.context.impl.resources.render.ResourceRenderRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class ResourceRenderRequestBuilder {
    private String method;
    private String url;

    private ResourceRenderRequestBuilder() {
    }

    public static ResourceRenderRequestBuilder create() {
        return new ResourceRenderRequestBuilder();
    }

    public ResourceRenderRequestBuilder setMethod(String method) {
        this.method = method;
        return this;
    }

    public ResourceRenderRequestBuilder setPath(String url) {
        this.url = url;
        return this;
    }

    public ResourceRenderRequest build() throws URISyntaxException, ResourceLoadingException {
        URI uri = new URI(this.url);
        String path = uri.getPath();
        List paramPairs = URLEncodedUtils.parse((URI)uri, (String)"UTF-8");
        Map<String, String[]> params = this.getParams(paramPairs);
        String decodedUrl = HttpResourceLoader.decodeUrl(path);
        ResourceRenderRequest request = new ResourceRenderRequest(this.method, decodedUrl, params);
        return request;
    }

    private Map<String, String[]> getParams(List<NameValuePair> paramPairs) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        for (NameValuePair pair : paramPairs) {
            if (params.containsKey(pair.getName())) {
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList((Object[])params.get(pair.getName())));
                list.add(pair.getValue());
                params.put(pair.getName(), list.toArray(new String[0]));
                continue;
            }
            params.put(pair.getName(), new String[]{pair.getValue()});
        }
        return params;
    }
}

