/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.resources.render;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRenderResponse
implements HttpServletResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceRenderResponse.class);
    private ServletOutputStream outputStream;
    private PrintWriter printWriter;
    private String contentType;
    private String charset;
    private int status = 200;
    private Map<String, Object> headers = new HashMap<String, Object>();

    public ResourceRenderResponse(OutputStream out) {
        this.outputStream = new PlainServletOutputStream(out);
    }

    public ServletOutputStream getOutputStream() {
        return this.outputStream;
    }

    public PrintWriter getWriter() {
        if (this.printWriter == null) {
            OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)this.getOutputStream(), StandardCharsets.UTF_8);
            this.printWriter = new PrintWriter((Writer)osWriter, true);
        }
        return this.printWriter;
    }

    public void flushBuffer() throws IOException {
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
        if (this.printWriter == null && this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public void resetBuffer() {
        try {
            this.flushBuffer();
        }
        catch (IOException e) {
            LOGGER.error("Couldn't flush buffer for the response.");
        }
    }

    public void reset() {
        this.resetBuffer();
    }

    public boolean isCommitted() {
        return false;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void addCookie(Cookie cookie) {
    }

    public void addDateHeader(String name, long date) {
        this.headers.put(name, date);
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.headers.put(name, value);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public String encodeURL(String url) {
        return null;
    }

    public String encodeUrl(String url) {
        return null;
    }

    public void sendError(int sc) {
    }

    public void sendError(int sc, String msg) {
    }

    public void sendRedirect(String location) {
    }

    public void setDateHeader(String name, long date) {
        this.headers.put(name, date);
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.put(name, value);
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public void setStatus(int sc, String sm) {
        this.status = sc;
    }

    public int getStatus() {
        return this.status;
    }

    public String getHeader(String name) {
        return this.headers.get(name) == null ? "" : this.headers.get(name).toString();
    }

    public Collection<String> getHeaders(String s) {
        return null;
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public int getBufferSize() {
        return 0;
    }

    public String getCharacterEncoding() {
        return this.charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return null;
    }

    public void setBufferSize(int size) {
    }

    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    public void setContentLength(int len) {
    }

    public void setContentLengthLong(long l) {
    }

    public void setLocale(Locale loc) {
    }

    public class PlainServletOutputStream
    extends ServletOutputStream {
        private final OutputStream outputStream;

        PlainServletOutputStream(OutputStream out) {
            this.outputStream = out;
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

