(function(document, XSS, $) {

    "use strict";
    var PROJECT_ID_CLASS_SELECTOR = '.smartling-touch-coral-project-id';
    var USER_IDENTIFIER_CLASS_SELECTOR = '.smartling-touch-coral-user-identifier';
    var USER_SECRET_CLASS_SELECTOR = '.smartling-touch-coral-user-secret';
    var LOCALE_CLASS_SELECTOR = '.smartling-touch-coral-locale';

    $(window).adaptTo("foundation-registry").register("foundation.validation.validator", {
        selector: LOCALE_CLASS_SELECTOR,
        validate: function(e) {
            var localeElement = $(e);
            return localeElement.val() ? '' : Granite.I18n.get("Please fill out this field");
        }
    });

    $(window).adaptTo("foundation-registry").register("foundation.validation.validator", {
      selector: PROJECT_ID_CLASS_SELECTOR,
      validate: function(e) {
          var projectIdElement = $(e);
          return projectIdElement.val() ? '' : Granite.I18n.get("Please fill out this field");
      }
    });

    $(window).adaptTo("foundation-registry").register("foundation.validation.validator", {
        selector: USER_IDENTIFIER_CLASS_SELECTOR,
        validate: function(e) {
            var userIdentifierElement = $(e);
            return userIdentifierElement.val() ? '' : Granite.I18n.get("Please fill out this field");
        }
    });

    $(window).adaptTo("foundation-registry").register("foundation.validation.validator", {
        selector: USER_SECRET_CLASS_SELECTOR,
        validate: function(e) {
            var tokenSecretElement = $(e);
            if (tokenSecretElement.val()) {
                return '';
            }
            var projectIdElement = tokenSecretElement.siblings('input.smartling-touch-coral-project-id');
            var userIdentifierElement = tokenSecretElement.siblings('input.smartling-touch-coral-user-identifier');
            if (projectIdElement.val() && projectIdElement.attr('initialValue') === projectIdElement.val() &&
                userIdentifierElement.val() && userIdentifierElement.attr('initialValue') === userIdentifierElement.val()) {
                return '';
            }
            return Granite.I18n.get("Please fill out this field");
        }
    });

})(document, _g.XSS, Granite.$);
