<%@ taglib prefix="cq" uri="http://www.day.com/taglibs/cq/1.0" %>
<%@page contentType="text/html" session="false" pageEncoding="utf-8"%>
<%@include file="/libs/foundation/global.jsp"%>
<%@include file="/libs/cq/cloudserviceconfigs/components/configpage/init.jsp"%>

<body>
    <cq:includeClientLib css="com.smartling.connector" />

    <div><cq:include path="trail" resourceType="cq/cloudserviceconfigs/components/trail"/></div>
    <p class="cq-clear-for-ie7"></p>
    <h1>${not empty currentPage.title ? currentPage.title : currentPage.name}</h1>
    <p>${currentPage.description}</p>
    <div>
        <script type="text/javascript">
            CQ.WCM.edit({
                "path":"${resource.path}",
                "dialog":"${component.path}/dialog",
                "type":"${resource.resourceType}",
                "editConfig":{
                    "xtype":"editbar",
                    "listeners":{
                        "afteredit":"REFRESH_PAGE"
                    },
                    "inlineEditing":CQ.wcm.EditBase.INLINE_MODE_NEVER,
                    "disableTargeting": true,
                    "actions":[
                        CQ.I18n.getMessage("Configuration"),
                        "-",
                        CQ.wcm.EditBase.EDIT,
                        "-",
                        "<a href='http://adobe.ly/1Je86ME' target='_blank' class='edit-bar__hyperlink'>Getting Started</span>",
                        "-",
                        {
                            text: "Test connection",
                            handler: function(){
                                var loadMask = new CQ.Ext.LoadMask(this.el, {
                                    'msg': CQ.I18n.getMessage('Checking configuration...')
                                });
                                loadMask.show();

                                var checkConnectionRequest = function(url, configPath, callback) {
                                    CQ.Ext.Ajax.request({
                                        url: url,
                                        method: 'GET',
                                        async: false,
                                        params: {
                                            configPath: configPath
                                        },
                                        success: function () {
                                            callback && callback();
                                        },
                                        failure: function (response) {
                                            callback && callback(CQ.Ext.decode(response.responseText).error.details[0]);
                                        }
                                    });
                                }
                                var configPath = this.path.replace("/jcr:content", "");
                                var showResult = function(errorText) {
                                    loadMask.hide();
                                    if (errorText) {
                                        CQ.Ext.Msg.show({
                                            title: "Connection Error: ",
                                            width: 300,
                                            msg: errorText,
                                            buttons: CQ.Ext.MessageBox.OK,
                                            icon: CQ.Ext.MessageBox.ERROR
                                        });
                                    } else {
                                        CQ.Ext.Msg.show({
                                            title: "Success",
                                            width: 300,
                                            msg: "Connection test was successful",
                                            buttons: CQ.Ext.MessageBox.OK,
                                            icon: CQ.Ext.MessageBox.INFO
                                        });
                                    }
                                }
                                var checkContextConnection = function() {
                                    checkConnectionRequest("/services/smartling/context/connection/check", configPath, showResult);
                                }
                                var checkCloudConfigConnection = function() {
                                    checkConnectionRequest("/services/smartling/cloud/config/connection/check", configPath, function(errorText) {
                                        if (errorText) {
                                            showResult(errorText)
                                        } else {
                                            checkContextConnection();
                                        }
                                    });
                                }
                                checkCloudConfigConnection();
                            }
                        }
                    ]
                }
            });
        </script>
    </div>

    <cq:include script="content.jsp" />
    <p>&nbsp;</p>
</body>