/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl;

import com.smartling.aem.connector.automation.CloudConfigResolver;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CloudConfigResolver.class})
public class CloudConfigResolverImpl
implements CloudConfigResolver {
    public static final String DAM_ROOT_FOLDER = "/content/dam";
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;

    @Override
    public SmartlingCloudConfig getConfigByResource(SmartlingCloudConfig config, Resource resource, String projectUid) {
        String path = resource.getPath();
        return this.getConfigByPath(config, resource.getResourceResolver(), path, projectUid);
    }

    @Override
    public SmartlingCloudConfig getConfigByPath(SmartlingCloudConfig config, ResourceResolver resourceResolver, String path, String projectUid) {
        if (StringUtils.isNotBlank((CharSequence)projectUid)) {
            return config.getForProject(projectUid);
        }
        LanguageCopyManager languageCopyManager = StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)DAM_ROOT_FOLDER) ? this.assetLanguageCopyManager : this.pageLanguageCopyManager;
        Language language = languageCopyManager.getLanguage(resourceResolver, path);
        return language == null ? config : config.getForLocale(language.getCode());
    }
}

