/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.property.mapping.servlet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingException;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingService;
import com.smartling.aem.connector.automation.impl.property.mapping.data.PropertyMappingContext;
import com.smartling.aem.connector.automation.impl.property.mapping.service.SmartlingPropertyMappingService;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Optional;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.methods=GET", "sling.servlet.paths=/services/smartling/property-mappings"})
public class PropertyMappingServlet
extends SlingAllMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingPropertyMappingService.class);
    private static final Gson GSON = new GsonBuilder().create();
    @Reference
    private PropertyMappingService propertyMappingService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        try {
            String context = URLDecoder.decode(request.getParameter(":context"), "UTF-8");
            Optional<PropertyMappingContext> mappingContext = this.propertyMappingService.getContextRulesRespectInheritance(context);
            if (mappingContext.isPresent()) {
                String responseBody = GSON.toJson((Object)mappingContext.get());
                response.setContentType("application/json");
                response.setStatus(200);
                response.getWriter().print(responseBody);
            } else {
                LOGGER.warn("There is no property mappings yet");
                response.getWriter().print("{}");
                response.setContentType("application/json");
                response.setStatus(200);
            }
        }
        catch (PropertyMappingException e) {
            LOGGER.error("Couldn't response property mappings", (Throwable)e);
            response.setStatus(500);
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        try {
            String data = request.getParameter("data");
            PropertyMappingContext mappingContext = (PropertyMappingContext)GSON.fromJson(data, PropertyMappingContext.class);
            this.propertyMappingService.updateContext(mappingContext);
            response.setStatus(200);
        }
        catch (PropertyMappingException e) {
            LOGGER.error("Couldn't updateMappings property mappings", (Throwable)e);
            response.setStatus(500);
        }
        catch (Exception e) {
            LOGGER.error("Internal error for updating property mappings", (Throwable)e);
            response.setStatus(500);
        }
    }
}

