/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.related;

import com.smartling.aem.connector.automation.impl.related.TranslatableNode;
import java.util.ArrayList;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NodeFilterRule {
    private static final Logger logger = LoggerFactory.getLogger(NodeFilterRule.class);
    private final String strPathContains;
    private final String strContainsProperty;
    private final String strPropertyValue;
    private final boolean bIsDeep;

    NodeFilterRule(String strPathContains, String strContainsProperty, String strPropertyValue, boolean bIsDeep) {
        this.strPathContains = strPathContains;
        this.strContainsProperty = strContainsProperty;
        this.strPropertyValue = strPropertyValue;
        this.bIsDeep = bIsDeep;
    }

    public String getStrPathContains() {
        return this.strPathContains;
    }

    public String getStrPropertyValue() {
        return this.strPropertyValue;
    }

    public boolean isValidBasedOnFilter(TranslatableNode currentNode) throws RepositoryException {
        boolean bValid;
        block10: {
            bValid = true;
            boolean bContinue = true;
            if (currentNode != null) {
                String strActualNodePath = currentNode.getPath();
                try {
                    if (!StringUtils.isEmpty((CharSequence)this.strPathContains) && strActualNodePath.contains(this.strPathContains)) {
                        bValid = false;
                    }
                    if (!bValid || StringUtils.isEmpty((CharSequence)this.strContainsProperty)) break block10;
                    TranslatableNode node = currentNode;
                    do {
                        if ((bValid = this.isNodeFilterPropertyValid(node, this.strContainsProperty)) && node.isPageNode()) {
                            bValid = this.isNodeFilterPropertyValid(node.getNode("jcr:content"), this.strContainsProperty);
                        }
                        if (this.bIsDeep && bValid) {
                            try {
                                node = node.getParent();
                            }
                            catch (Exception e) {
                                node = null;
                            }
                            if (node != null) continue;
                            bContinue = false;
                            continue;
                        }
                        bContinue = false;
                    } while (bContinue);
                }
                catch (Exception ex) {
                    logger.error("Error while processing the filter ", (Throwable)ex);
                    bValid = false;
                }
            } else {
                bValid = false;
            }
        }
        return bValid;
    }

    public static void copyFilters(ArrayList<NodeFilterRule> childRules, ArrayList<NodeFilterRule> parentRules) {
        if (childRules != null && parentRules != null && parentRules.size() > 0) {
            for (NodeFilterRule filterRule : parentRules) {
                NodeFilterRule newFilter = new NodeFilterRule(filterRule.strPathContains, filterRule.strContainsProperty, filterRule.strPropertyValue, filterRule.bIsDeep);
                childRules.add(newFilter);
            }
        }
    }

    private boolean isNodeFilterPropertyValid(TranslatableNode node, String strContainsProperty) throws RepositoryException {
        boolean bValid = true;
        if (node != null && node.hasProperty(strContainsProperty)) {
            Property prop = node.getProperty(strContainsProperty);
            if (!StringUtils.isEmpty((CharSequence)this.strPropertyValue)) {
                int type = prop.getType();
                String strValue = "";
                switch (type) {
                    case 6: {
                        strValue = prop.getBoolean() ? "true" : "false";
                        break;
                    }
                    case 1: {
                        strValue = prop.getString();
                        break;
                    }
                    case 4: {
                        strValue = new Double(prop.getDouble()).toString();
                        break;
                    }
                    case 3: {
                        strValue = new Long(prop.getLong()).toString();
                    }
                }
                if (this.strPropertyValue.equals(strValue)) {
                    bValid = false;
                }
            }
        }
        return bValid;
    }
}

