/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.related;

import com.smartling.aem.connector.automation.impl.related.AssetNodeRule;
import com.smartling.aem.connector.automation.impl.related.NodeRule;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetUtils;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetsException;
import com.smartling.aem.connector.automation.impl.related.TranslatableNode;
import com.smartling.aem.connector.automation.impl.related.TranslationRulesFileParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class TranslationRuleProvider {
    public static final String JCR_DATA = "jcr:data";
    public static final String JCR_CONTENT = "jcr:content";
    private final TranslationRulesFileParser parser;
    private final ResourceResolver resourceResolver;

    public TranslationRuleProvider(ResourceResolver resourceResolver, TranslationRulesFileParser parser) {
        this.resourceResolver = resourceResolver;
        this.parser = parser;
    }

    public boolean canTranslateNode(TranslatableNode node) throws RelatedAssetsException {
        String strNodePrimaryType = node.getNodePrimaryType();
        return this.canTranslateNode(node, strNodePrimaryType);
    }

    private boolean canTranslateNode(TranslatableNode node, String strNodePrimaryType) throws RelatedAssetsException {
        boolean bRetVal = false;
        try {
            if (!this.isNodePropertyTranslatable(node)) {
                for (TranslatableNode childNode : node.getChildNodes()) {
                    if (!childNode.isNodeOfPrimaryType(strNodePrimaryType) && (bRetVal = this.canTranslateNode(childNode, strNodePrimaryType))) break;
                }
            } else {
                bRetVal = true;
            }
        }
        catch (RepositoryException e) {
            throw new RelatedAssetsException("Couldn't check translation node", e);
        }
        return bRetVal;
    }

    public AssetNodeRule getAssetNodeFileRule(String strResourceType) {
        String currentRT = strResourceType;
        while (currentRT != null) {
            AssetNodeRule assetNodeRule = this.parser.getAssetNodeRule(currentRT);
            if (assetNodeRule != null) {
                String strFileReferenceAttribute = assetNodeRule.getStrFileReferenceAttribute();
                return new AssetNodeRule(strResourceType, strFileReferenceAttribute);
            }
            currentRT = this.resourceResolver.getParentResourceType(currentRT);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TranslationRuleProvider initialize(ResourceResolver resourceResolver) throws RelatedAssetsException {
        String strFilePath = RelatedAssetUtils.getTranslationRulesFileLocation(resourceResolver);
        Resource resource = resourceResolver.getResource(strFilePath);
        if (resource == null) {
            throw new RelatedAssetsException(String.format("Couldn't find translation rules file path=\"%s\"", strFilePath));
        }
        try {
            Node node = (Node)resource.adaptTo(Node.class);
            Node jcrContent = node.getNode(JCR_CONTENT);
            try (InputStream contentStream = jcrContent.getProperty(JCR_DATA).getBinary().getStream();){
                TranslationRulesFileParser parser = TranslationRulesFileParser.initialize(contentStream);
                TranslationRuleProvider translationRuleProvider = new TranslationRuleProvider(resourceResolver, parser);
                return translationRuleProvider;
            }
        }
        catch (IOException | RepositoryException e) {
            throw new RelatedAssetsException("Couldn't initialize translation rules", e);
        }
    }

    private String removeEndBackslash(String strNodePath) {
        if (strNodePath.endsWith("/")) {
            strNodePath = strNodePath.substring(0, strNodePath.length() - 1);
        }
        return strNodePath;
    }

    private NodeRule getNodeRuleWithResourceType(String path, ArrayList<String> resourceTypeList, String strActualNodePath) throws RelatedAssetsException {
        NodeRule retVal = null;
        for (int index = 0; index < resourceTypeList.size() && retVal == null; ++index) {
            retVal = this.getNodeRule(path, resourceTypeList.get(index), strActualNodePath);
        }
        return retVal;
    }

    private NodeRule getMatchingNodeRule(TranslatableNode node, String strActualNodePath, ArrayList<String> resourceTypeList) throws RepositoryException, RelatedAssetsException {
        NodeRule nodeRule = null;
        if (node != null) {
            String strResourceType = node.getNodeResourceType();
            if (!StringUtils.isEmpty((CharSequence)strResourceType) && !resourceTypeList.contains(strResourceType)) {
                resourceTypeList.add(strResourceType);
            }
            if ((nodeRule = this.getNodeRuleWithResourceType(node.getPath(), resourceTypeList, strActualNodePath)) == null) {
                nodeRule = this.getNodeRule(node.getPath(), "", strActualNodePath);
            }
            if (nodeRule == null) {
                TranslatableNode parentNode = null;
                try {
                    parentNode = node.getParent();
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                nodeRule = this.getMatchingNodeRule(parentNode, strActualNodePath, resourceTypeList);
            }
        }
        return nodeRule;
    }

    private ArrayList<String> getTranslatablePropertyListForNode(TranslatableNode inputNode) throws RepositoryException, RelatedAssetsException {
        ArrayList<String> strRetList = new ArrayList<String>();
        NodeRule nodeRule = this.getNodeRuleFromInputNode(inputNode);
        if (nodeRule != null) {
            strRetList = nodeRule.getTranslatablePropertyList();
        }
        return strRetList;
    }

    private NodeRule getNodeRuleFromInputNode(TranslatableNode inputNode) throws RepositoryException, RelatedAssetsException {
        NodeRule nodeRule;
        String strResourceType = inputNode.getNodeResourceType();
        ArrayList<String> resourceTypeList = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)strResourceType)) {
            resourceTypeList.add(strResourceType);
        }
        if ((nodeRule = this.getMatchingNodeRule(inputNode, inputNode.getPath(), resourceTypeList)) != null && nodeRule.isValidBasedOnFilters(inputNode)) {
            return nodeRule;
        }
        return null;
    }

    private boolean isNodePropertyTranslatable(TranslatableNode node) throws RepositoryException, RelatedAssetsException {
        ArrayList<String> propList;
        boolean bRetVal = false;
        if (node != null && (propList = this.getTranslatablePropertyListForNode(node)) != null && propList.size() > 0) {
            for (String propertyName : propList) {
                if (!node.hasProperty(propertyName)) continue;
                bRetVal = true;
                break;
            }
        }
        return bRetVal;
    }

    private NodeRule getNodeRule(String strNodePath, String strResourceType, String strActualNodePath) {
        strNodePath = this.removeEndBackslash(strNodePath);
        strNodePath = strNodePath.toLowerCase();
        if (StringUtils.isEmpty((CharSequence)strResourceType)) {
            strResourceType = "";
        } else {
            strResourceType = this.removeEndBackslash(strResourceType);
            strResourceType = strResourceType.toLowerCase();
        }
        NodeRule nodeRule = this.parser.findWithContainsOnlyRuleFromArray(strNodePath, strResourceType, strActualNodePath);
        if (nodeRule == null) {
            nodeRule = this.parser.findRuleFromArray(strNodePath, strResourceType, strActualNodePath);
        }
        return nodeRule;
    }
}

