/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.project;

import com.day.cq.commons.jcr.JcrUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.smartling.aem.connector.automation.impl.TranslationJob;
import com.smartling.aem.connector.automation.impl.TranslationProject;
import com.smartling.aem.connector.automation.impl.TranslationProjectException;
import com.smartling.aem.connector.automation.impl.TranslationProjectManager;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationJobResource;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationProjectCreateOptions;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationProjectResource;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={TranslationProjectManager.class}, immediate=true)
@Designate(ocd=Config.class)
public class TranslationProjectResourceManager
implements TranslationProjectManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslationProjectResourceManager.class);
    private static final Gson GSON = new GsonBuilder().create();
    private static final String PROJECTS_ROOT = "/content/projects";
    private static final String SMARTLING_PROJECTS_ROOT = "smartling-auto";
    private static final String TRANSLATION_OBJECT_QUERY = "SELECT * FROM [nt:unstructured] AS s WHERE ISDESCENDANTNODE('%s') and s.translationObjectID='%s'";
    public static final String PROJECT_RESOURCE_TYPE = "cq/gui/components/projects/admin/card/projectcard";
    public static final String SLING_RESOURCE_TYPE_PROPERTY_NAME = "sling:resourceType";
    public static final String TRANSLATION_AUTOMATIC_APPROVE_ENABLE_SETTING = "translationAutomaticApproveEnable";
    public static final String TRANSLATION_AUTOMATIC_DELETE_ENABLE_SETTING = "translationAutomaticDeleteLaunchEnable";
    public static final String TRANSLATION_AUTOMATIC_PROMOTE_LAUNCH_ENABLE_SETTING = "translationAutomaticPromoteLaunchEnable";
    public static final int POLLING_RETRY_COUNT_MAX_VALUE = 50;
    public static final int POLLING_RETRY_COUNT_MIN_VALUE = 10;
    public static final int POLLING_RETRY_COUNT_DEFAULT_VALUE = 40;
    public static final int POLLING_RETRY_SLEEP_IN_MILLIS_MAX_VALUE = 500;
    public static final int POLLING_RETRY_SLEEP_IN_MILLIS_MIN_VALUE = 100;
    public static final int POLLING_RETRY_SLEEP_IN_MILLIS_DEFAULT_VALUE = 300;
    public static final int POLLING_UPLOAD_COMPLETE_IN_MINUTES_MAX_VALUE = 30;
    public static final int POLLING_UPLOAD_COMPLETE_IN_MINUTES_MIN_VALUE = 10;
    public static final int POLLING_UPLOAD_COMPLETE_IN_MINUTES_DEFAULT_VALUE = 20;
    public static final boolean AUTO_APPROVE_ENABLE_DEFAULT_VALUE = true;
    public static final boolean AUTO_DELETE_LAUNCH_ENABLE_DEFAULT_VALUE = true;
    public static final boolean AUTO_PROMOTE_LAUNCH_ENABLE_DEFAULT_VALUE = true;
    private int pollingRetryCount;
    private int pollingRetrySleep;
    private int pollingUploadComplete;
    private boolean autoApproveEnable;
    private boolean autoDeleteEnable;
    private boolean autoPromoteLaunchEnable;
    @Reference
    private SlingRepository repository;

    @Activate
    protected void activate(Config config) {
        this.pollingRetryCount = 40;
        try {
            this.pollingRetryCount = Math.max(config.polling_retry_count(), 10);
            this.pollingRetryCount = Math.min(this.pollingRetryCount, 50);
        }
        catch (Exception e) {
            LOGGER.error("Error while setting polling retry count. Default value '{}' was applied", (Object)40, (Object)e);
        }
        this.pollingRetrySleep = 300;
        try {
            this.pollingRetrySleep = Math.max(config.polling_retry_sleep(), 100);
            this.pollingRetrySleep = Math.min(this.pollingRetrySleep, 500);
        }
        catch (Exception e) {
            LOGGER.error("Error while setting polling retry sleep. Default value '{}' was applied", (Object)300, (Object)e);
        }
        this.pollingUploadComplete = 20;
        try {
            this.pollingUploadComplete = Math.max(config.polling_upload_complete(), 10);
            this.pollingUploadComplete = Math.min(this.pollingUploadComplete, 30);
        }
        catch (Exception e) {
            LOGGER.error("Error while setting polling upload complete period. Default value '{}' was applied", (Object)20, (Object)e);
        }
        this.autoApproveEnable = config.translation_project_enable_approve();
        this.autoDeleteEnable = config.translation_project_enable_delete();
        this.autoPromoteLaunchEnable = config.translation_project_enable_promote_launch();
    }

    @Override
    public String createProjectFolder(ResourceResolver resourceResolver, TranslationProjectCreateOptions options) throws TranslationProjectException {
        try {
            return this.createProjectFolderNode(resourceResolver, options).getPath();
        }
        catch (RepositoryException e) {
            throw new TranslationProjectException("Failed to create project folder:", e);
        }
    }

    @Override
    public TranslationProject getProject(ResourceResolver resourceResolver, String projectPath) {
        Resource projectContentResource = resourceResolver.resolve(projectPath).getChild("jcr:content");
        if (projectContentResource != null) {
            return new TranslationProjectResource(projectContentResource);
        }
        return null;
    }

    @Override
    public TranslationProject getProjectByTranslationJobId(ResourceResolver resourceResolver, String translationJobId) throws TranslationProjectException {
        Node translationJobNode = this.getTranslationJobNode(resourceResolver, translationJobId);
        String projectPath = this.findProjectPath(translationJobNode);
        Resource projectResource = resourceResolver.getResource(projectPath);
        if (projectResource == null) {
            throw new TranslationProjectException(String.format("Couldn't find translation project by path=\"%s\"", projectPath));
        }
        return new TranslationProjectResource(projectResource.getChild("jcr:content"));
    }

    @Override
    public TranslationJob getTranslationJobById(ResourceResolver resourceResolver, String translationJobId) throws TranslationProjectException {
        try {
            Node translationJobNode = this.getTranslationJobNode(resourceResolver, translationJobId);
            Resource translationJobResource = resourceResolver.getResource(translationJobNode.getPath());
            return new TranslationJobResource(translationJobResource);
        }
        catch (RepositoryException e) {
            throw new TranslationProjectException(String.format("Couldn't get translation job resource by jobId=\"%s\"", translationJobId), e);
        }
    }

    @Override
    public boolean applyProjectCustomizations(ResourceResolver resourceResolver, String projectPath) {
        String projectContentPath = projectPath + "/" + "jcr:content";
        Resource projectContent = resourceResolver.resolve(projectContentPath);
        if (ResourceUtil.isNonExistingResource((Resource)projectContent)) {
            LOGGER.warn("Project content path=\"{}\" haven't been created yet.", (Object)projectContentPath);
            return false;
        }
        Node projectContentNode = (Node)projectContent.adaptTo(Node.class);
        if (projectContentNode == null) {
            LOGGER.error("Project content path=\"{}\" is not a JCR node.", (Object)projectContentPath);
            return true;
        }
        try {
            if (!projectContentNode.hasProperty(TRANSLATION_AUTOMATIC_APPROVE_ENABLE_SETTING)) {
                LOGGER.warn("Project content path=\"{}\" doesn't have a property=\"{}\"", (Object)projectContentPath, (Object)TRANSLATION_AUTOMATIC_APPROVE_ENABLE_SETTING);
                return false;
            }
            projectContentNode.setProperty(TRANSLATION_AUTOMATIC_APPROVE_ENABLE_SETTING, this.autoApproveEnable);
            if (!projectContentNode.hasProperty(TRANSLATION_AUTOMATIC_DELETE_ENABLE_SETTING)) {
                LOGGER.warn("Project content path=\"{}\" doesn't have a property=\"{}\"", (Object)projectContentPath, (Object)TRANSLATION_AUTOMATIC_DELETE_ENABLE_SETTING);
                return false;
            }
            projectContentNode.setProperty(TRANSLATION_AUTOMATIC_DELETE_ENABLE_SETTING, this.autoDeleteEnable);
            if (!projectContentNode.hasProperty(TRANSLATION_AUTOMATIC_PROMOTE_LAUNCH_ENABLE_SETTING)) {
                LOGGER.warn("Project content path=\"{}\" doesn't have a property=\"{}\"", (Object)projectContentPath, (Object)TRANSLATION_AUTOMATIC_PROMOTE_LAUNCH_ENABLE_SETTING);
                return false;
            }
            projectContentNode.setProperty(TRANSLATION_AUTOMATIC_PROMOTE_LAUNCH_ENABLE_SETTING, this.autoPromoteLaunchEnable);
            resourceResolver.commit();
            LOGGER.info("Project path=\"{}\" is customized successfully", (Object)projectPath);
        }
        catch (RepositoryException | PersistenceException e) {
            LOGGER.error("Failed to customize translation project path=\"{}\"", (Object)projectPath, (Object)e);
        }
        return true;
    }

    private Node getTranslationJobNode(ResourceResolver resourceResolver, String translationJobId) throws TranslationProjectException {
        try {
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            String queryString = String.format(TRANSLATION_OBJECT_QUERY, PROJECTS_ROOT, translationJobId);
            Query query = session.getWorkspace().getQueryManager().createQuery(queryString, "JCR-SQL2");
            NodeIterator nodes = this.getNodesWithRetries(translationJobId, query);
            if (nodes != null && nodes.hasNext()) {
                return nodes.nextNode();
            }
            throw new TranslationProjectException(String.format("Couldn't find translation job by jobId=\"%s\"", translationJobId));
        }
        catch (RepositoryException e) {
            throw new TranslationProjectException(String.format("Failed to get translation job by jobId=\"%s\"", translationJobId), e);
        }
    }

    public int getPollingRetryCount() {
        return this.pollingRetryCount;
    }

    public int getPollingRetrySleep() {
        return this.pollingRetrySleep;
    }

    @Override
    public int getPollingUploadComplete() {
        return this.pollingUploadComplete;
    }

    private NodeIterator getNodesWithRetries(String translationJobId, Query query) {
        NodeIterator nodeIterator = null;
        try {
            for (int retryCounter = 1; retryCounter < this.pollingRetryCount; ++retryCounter) {
                try {
                    LOGGER.info("Going to find Translation job node by translationJobId=\"{}\"", (Object)translationJobId);
                    nodeIterator = query.execute().getNodes();
                }
                catch (RepositoryException e) {
                    LOGGER.error("Failed to find translation project by object job id=\"{}\"", (Object)translationJobId, (Object)e);
                    break;
                }
                if (nodeIterator.hasNext()) {
                    return nodeIterator;
                }
                Thread.sleep(this.pollingRetrySleep);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.error("Thread is interrupted on retrying to find Translation Job node", (Throwable)ex);
        }
        return nodeIterator;
    }

    private String findProjectPath(Node translationObjectNode) throws TranslationProjectException {
        String translationObjectNodePath = null;
        try {
            Node seekNode;
            translationObjectNodePath = translationObjectNode.getPath();
            for (seekNode = translationObjectNode; seekNode != null && !PROJECT_RESOURCE_TYPE.equalsIgnoreCase(JcrUtils.getStringProperty((Node)seekNode, (String)SLING_RESOURCE_TYPE_PROPERTY_NAME, (String)"")); seekNode = seekNode.getParent()) {
            }
            if (seekNode == null) {
                throw new TranslationProjectException(String.format("Couldn't find translation project for node \"%s\"", translationObjectNodePath));
            }
            return seekNode.getPath();
        }
        catch (RepositoryException ex) {
            throw new TranslationProjectException(String.format("Couldn't find translation project for node \"%s\"", translationObjectNodePath));
        }
    }

    private Node createProjectFolderNode(ResourceResolver resourceResolver, TranslationProjectCreateOptions options) throws RepositoryException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        String projectFolderRelativePath = TranslationProjectResourceManager.generateProjectFolderRelativePath(SMARTLING_PROJECTS_ROOT);
        String folderName = TranslationProjectResourceManager.generateProjectFolderNodeName(options.getTitle());
        Node projectFolderNode = this.createInSeparateSession(session, projectFolderRelativePath + "/" + folderName);
        projectFolderNode.setProperty("jobUid", options.getJobUid());
        projectFolderNode.setProperty("batchUid", options.getBatchUid());
        projectFolderNode.setProperty("configSourceLocaleCode", options.getConfigSourceLocaleCode());
        projectFolderNode.setProperty("userId", options.getUserId());
        projectFolderNode.setProperty("projectUid", options.getProjectUid());
        projectFolderNode.setProperty("pseudo", options.isPseudo());
        projectFolderNode.setProperty("autoAuthorize", options.isAutoAuthorize());
        if (CollectionUtils.isNotEmpty(options.getLocaleWorkflows())) {
            projectFolderNode.setProperty("localeWorkflows", GSON.toJson(options.getLocaleWorkflows()));
        }
        session.save();
        LOGGER.info("Created projectFolder=\"{}\" with the following options: {}", (Object)projectFolderNode.getPath(), (Object)options);
        return projectFolderNode;
    }

    private static String generateProjectFolderNodeName(String title) {
        SimpleDateFormat timeOfTheDay = new SimpleDateFormat("HH-mm-ss-S");
        String nodeName = StringUtils.length((CharSequence)title) > 51 ? StringUtils.left((String)title, (int)51) : title;
        nodeName = nodeName + "-" + timeOfTheDay.format(new Date());
        return JcrUtil.createValidName((String)nodeName);
    }

    private static String generateProjectFolderRelativePath(String name) {
        SimpleDateFormat dayOfTheYear = new SimpleDateFormat("yyyy/MM/dd");
        return name + "/" + dayOfTheYear.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createInSeparateSession(Session session, String path) throws RepositoryException {
        if (session.nodeExists("/content/projects/" + path)) {
            return session.getNode("/content/projects/" + path);
        }
        Session serviceSession = this.repository.loginService(null, null);
        try {
            Node folderNode = TranslationProjectResourceManager.getOrCreateFolder(serviceSession, path);
            session.refresh(true);
            Node node = session.getNode(folderNode.getPath());
            return node;
        }
        finally {
            serviceSession.logout();
        }
    }

    private static Node getOrCreateFolder(Session session, String relativePath) throws RepositoryException {
        List segments = Arrays.stream(StringUtils.split((String)relativePath, (char)'/')).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Node node = session.getNode(PROJECTS_ROOT);
        for (String nextNodeName : segments) {
            try {
                Node child = node.addNode(nextNodeName, "sling:OrderedFolder");
                child.setProperty(SLING_RESOURCE_TYPE_PROPERTY_NAME, "cq/gui/components/projects/admin/card/foldercard");
                child.setProperty("jcr:title", nextNodeName);
                session.save();
            }
            catch (RepositoryException e) {
                if (node.hasNode(nextNodeName)) {
                    session.refresh(false);
                }
                throw e;
            }
            node = node.getNode(nextNodeName);
        }
        return node;
    }

    @ObjectClassDefinition(name="Smartling - Translation Project Manager (Touch)", description="Entry point for any processing related to AEM translation project")
    public static @interface Config {
        @AttributeDefinition(name="Polling retry count", description="Retry count for searching a project by job ID. Min 10, max 50")
        public int polling_retry_count() default 40;

        @AttributeDefinition(name="Polling retry sleep period in ms", description="Sleep periods between tries for searching a project by job ID in ms. Min 100ms, max 500ms")
        public int polling_retry_sleep() default 300;

        @AttributeDefinition(name="Polling upload complete period in minutes", description="Polling periods between checks for uploading is completed in minutes. Min 10mins, max 30mins")
        public int polling_upload_complete() default 20;

        @AttributeDefinition(name="Enable Automatic Approve", description="Enables / Disables automatic approve translation project feature.")
        public boolean translation_project_enable_approve() default true;

        @AttributeDefinition(name="Enable Automatic Delete Launch", description="Enables / Disables automatic delete launch feature.")
        public boolean translation_project_enable_delete() default true;

        @AttributeDefinition(name="Enable Automatic Promote Launch", description="Enables / Disables automatic promote launch feature.")
        public boolean translation_project_enable_promote_launch() default true;
    }
}

