/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.model.WorkflowModel;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.WcmWorkflows;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WcmWorkflows.class})
public class WcmWorkflowsImpl
implements WcmWorkflows {
    private static final Logger LOGGER = LoggerFactory.getLogger(WcmWorkflowsImpl.class);
    private static final String CREATE_LANGUAGE_COPY = "/etc/workflow/models/wcm-translation/create_language_copy/jcr:content/model";
    private static final String UPDATE_LANGUAGE_COPY = "/etc/workflow/models/wcm-translation/update_language_copy/jcr:content/model";
    private static final String SYNC_TRANSLATION_JOB = "/etc/workflow/models/wcm-translation/sync_translation_job/jcr:content/model";
    public static final String PREPARE_TRANSLATION_PROJECT = "/etc/workflow/models/wcm-translation/prepare_translation_project/jcr:content/model";
    public static final String PROJECT_FOLDER_PATH_PARAM = "projectFolderPath";
    public static final String PROJECT_TYPE_PARAM = "projectType";
    public static final String TRANSLATION_WORKFLOW_MODEL_PARAM = "translationWorkflowModel";
    private static final String LAUNCH_TITLE_PARAM = "workflowLaunchTitle";
    public static final String WORKFLOW_TITLE_PARAM = "workflowTitle";
    private static final String IS_DEEP_PARAM = "deep";
    private static final String CREATE_NON_EMPTY_ANCESTORS_PARAM = "createNonEmptyAncestors";
    private static final String DESTINATION_LANGUAGE = "destinationLanguage";
    private static final String UPDATE_WORKFLOW_SOURCE_LOCALE_PARAM = "language";
    private static final String CREATE_WORKFLOW_TARGET_LOCALE_PARAM = "language";
    private static final String PROJECT_FOLDER_LANGUAGE_REF_COUNT_PARAM = "projectFolderLanguageRefCount";
    public static final String PROJECT_TITLE_PARAM = "projectTitle";
    private static final String SOURCE_PATH_LIST_PARAM = "sourcePathList";
    private static final String LANGUAGE_LIST_PARAM = "languageList";
    public static final String TRANSLATE_LANGUAGES_PARAM = "translateLanguages";
    public static final String ADD_NEW_MULTI_LANG_PROJECT_MODE = "add_new_multi_lang";
    public static final String LANGUAGE = "language";
    public static final String INITIATOR_USER_ID = "initiatorUserId";
    public static final String CREATED_COPIES = "createdCopies";
    public static final String UPDATE_ASSETS_WORKFLOW = "updateAssetsWorkflow";
    public static final String ASSET_UPDATE_SOURCE_ROOT = "assetUpdateSourceRoot";
    public static final String SOURCE_PATH_LIST = "sourcePathList";
    public static final String LANGUAGE_LIST = "languageList";
    public static final String ADD_ASSET = "addAsset";
    public static final String ADD_EMBEDDED_ASSETS = "addEmbeddedAssets";

    @Override
    public void createLanguageCopy(WorkflowSession workflowSession, String sourcePagePath, WcmWorkflows.Parameters parameters) throws WorkflowException {
        if (CollectionUtils.isEmpty(parameters.getLanguageCopies())) {
            throw new WorkflowException(String.format("List of target languages is empty for project=\"%s\", source page=\"%s\"", parameters.getTitle(), sourcePagePath));
        }
        String languageList = parameters.getLanguageCopies().stream().map(l -> l.getLanguage().getCode()).collect(Collectors.joining(","));
        HashMap<String, Object> workflowParameters = new HashMap<String, Object>();
        workflowParameters.put("language", parameters.getLanguageCopies().get(0).getLanguage().getCode());
        workflowParameters.put(CREATE_NON_EMPTY_ANCESTORS_PARAM, parameters.isCreateNonEmptyAncestors());
        workflowParameters.put(IS_DEEP_PARAM, parameters.isDeep());
        workflowParameters.put(TRANSLATION_WORKFLOW_MODEL_PARAM, PREPARE_TRANSLATION_PROJECT);
        workflowParameters.put(PROJECT_TYPE_PARAM, ADD_NEW_MULTI_LANG_PROJECT_MODE);
        workflowParameters.put(PROJECT_FOLDER_PATH_PARAM, parameters.getFolderPath());
        workflowParameters.put(PROJECT_FOLDER_LANGUAGE_REF_COUNT_PARAM, String.valueOf(parameters.getLanguageCopies().size()));
        workflowParameters.put(PROJECT_TITLE_PARAM, parameters.getTitle());
        workflowParameters.put("languageList", languageList);
        this.startWorkflow(workflowSession, CREATE_LANGUAGE_COPY, sourcePagePath, workflowParameters);
        LOGGER.info("Started 'WCM: Create Language Copy' workflow for path=\"{}\", language=\"{}\"", (Object)sourcePagePath, (Object)languageList);
    }

    @Override
    public void updateLanguageCopy(WorkflowSession workflowSession, WcmWorkflows.Parameters parameters) throws WorkflowException {
        if (CollectionUtils.isEmpty(parameters.getLanguageCopies())) {
            throw new WorkflowException(String.format("List of target languages is empty for project=\"%s\"", parameters.getTitle()));
        }
        String sourcePathList = parameters.getLanguageCopies().stream().map(l -> l.getPath()).collect(Collectors.joining(";"));
        String languageList = parameters.getLanguageCopies().stream().map(l -> l.getLanguage().getCode()).distinct().collect(Collectors.joining(","));
        HashMap<String, Object> workflowParameters = new HashMap<String, Object>();
        workflowParameters.put("language", parameters.getSourceLanguage());
        workflowParameters.put(DESTINATION_LANGUAGE, parameters.getLanguageCopies().get(0).getLanguage().getCode());
        workflowParameters.put(CREATE_NON_EMPTY_ANCESTORS_PARAM, parameters.isCreateNonEmptyAncestors());
        workflowParameters.put(IS_DEEP_PARAM, parameters.isDeep());
        workflowParameters.put(LAUNCH_TITLE_PARAM, WcmWorkflowsImpl.buildLaunchTitle(parameters));
        workflowParameters.put(TRANSLATION_WORKFLOW_MODEL_PARAM, PREPARE_TRANSLATION_PROJECT);
        workflowParameters.put(PROJECT_TYPE_PARAM, ADD_NEW_MULTI_LANG_PROJECT_MODE);
        workflowParameters.put(PROJECT_FOLDER_PATH_PARAM, parameters.getFolderPath());
        workflowParameters.put(PROJECT_FOLDER_LANGUAGE_REF_COUNT_PARAM, String.valueOf(parameters.getLanguageCopies().size()));
        workflowParameters.put(PROJECT_TITLE_PARAM, parameters.getTitle());
        workflowParameters.put("sourcePathList", sourcePathList);
        workflowParameters.put("languageList", languageList);
        this.startWorkflow(workflowSession, UPDATE_LANGUAGE_COPY, parameters.getLanguageCopies().get(0).getPath(), workflowParameters);
        LOGGER.info("Started 'WCM: Update Language Copy' workflow for paths=\"{}\", languages=\"{}\"", (Object)sourcePathList, (Object)languageList);
    }

    @Override
    public void syncTranslationJob(WorkflowSession workflowSession, String translationJobPath) throws WorkflowException {
        this.startWorkflow(workflowSession, SYNC_TRANSLATION_JOB, translationJobPath, new HashMap<String, Object>());
        LOGGER.info("Started 'WCM: Sync Translation Job' workflow for path=\"{}\"", (Object)translationJobPath);
    }

    @Override
    public void prepareAssetLanguageCopy(WorkflowSession workflowSession, WcmWorkflows.Parameters parameters) throws WorkflowException {
        Object[] languageCopies = (String[])parameters.getLanguageCopies().stream().map(LanguageCopyManager.LanguageCopy::getPath).toArray(String[]::new);
        String sourcePathList = StringUtils.join((Object[])languageCopies, (String)";");
        String languageList = parameters.getLanguageCopies().stream().map(l -> l.getLanguage().getCode()).distinct().collect(Collectors.joining(";"));
        HashMap<String, Object> workflowParameters = new HashMap<String, Object>();
        workflowParameters.put(TRANSLATION_WORKFLOW_MODEL_PARAM, PREPARE_TRANSLATION_PROJECT);
        workflowParameters.put(PROJECT_TYPE_PARAM, ADD_NEW_MULTI_LANG_PROJECT_MODE);
        workflowParameters.put(PROJECT_TITLE_PARAM, parameters.getTitle());
        workflowParameters.put(PROJECT_FOLDER_PATH_PARAM, parameters.getFolderPath());
        workflowParameters.put(TRANSLATE_LANGUAGES_PARAM, languageList);
        workflowParameters.put(WORKFLOW_TITLE_PARAM, WcmWorkflowsImpl.buildLaunchTitle(parameters));
        workflowParameters.put("language", parameters.getSourceLanguage());
        workflowParameters.put(INITIATOR_USER_ID, parameters.getInitiatorUserID());
        workflowParameters.put(CREATED_COPIES, languageCopies);
        workflowParameters.put(UPDATE_ASSETS_WORKFLOW, "true");
        workflowParameters.put(ASSET_UPDATE_SOURCE_ROOT, parameters.getSourcePaths().get(0));
        WorkflowModel workflowModel = workflowSession.getModel(PREPARE_TRANSLATION_PROJECT);
        WorkflowData workflowData = workflowSession.newWorkflowData("JCR_PATH", languageCopies[0]);
        workflowData.getMetaDataMap().put((Object)"sourcePathList", (Object)sourcePathList);
        workflowData.getMetaDataMap().put((Object)"languageList", (Object)languageList);
        workflowSession.startWorkflow(workflowModel, workflowData, workflowParameters);
        LOGGER.info("Started 'Workflow to Prepare Translation Project' workflow for paths=\"{}\", languages=\"{}\"", (Object)sourcePathList, (Object)languageList);
    }

    @Override
    public void prepareFormLanguageCopy(WorkflowSession workflowSession, WcmWorkflows.Parameters parameters) throws WorkflowException {
        List targetLanguages = parameters.getLanguageCopies().stream().map(LanguageCopyManager.LanguageCopy::getLanguage).map(Language::getCode).collect(Collectors.toList());
        for (String destinationLanguage : targetLanguages) {
            HashMap<String, Object> workflowParameters = new HashMap<String, Object>();
            WorkflowModel workflowModel = workflowSession.getModel(PREPARE_TRANSLATION_PROJECT);
            workflowParameters.put(ADD_ASSET, false);
            workflowParameters.put(ADD_EMBEDDED_ASSETS, false);
            workflowParameters.put("language", parameters.getSourceLanguage());
            workflowParameters.put(PROJECT_TITLE_PARAM, parameters.getTitle() + "(" + destinationLanguage + ")");
            workflowParameters.put(PROJECT_FOLDER_PATH_PARAM, parameters.getFolderPath());
            workflowParameters.put(DESTINATION_LANGUAGE, destinationLanguage);
            workflowParameters.put(PROJECT_TYPE_PARAM, ADD_NEW_MULTI_LANG_PROJECT_MODE);
            WorkflowData workflowData = workflowSession.newWorkflowData("JCR_PATH", (Object)parameters.getSourcePaths().get(0));
            workflowSession.startWorkflow(workflowModel, workflowData, workflowParameters);
        }
    }

    private static String buildLaunchTitle(WcmWorkflows.Parameters parameters) {
        return StringUtils.substring((String)parameters.getSourcePageTitle().replaceAll("[^a-zA-Z0-9-_ ]", ""), (int)0, (int)35);
    }

    private void startWorkflow(WorkflowSession workflowSession, String modelPath, String payloadPath, Map<String, Object> parameters) throws WorkflowException {
        WorkflowModel workflowModel = workflowSession.getModel(modelPath);
        WorkflowData workflowData = workflowSession.newWorkflowData("JCR_PATH", (Object)payloadPath);
        workflowSession.startWorkflow(workflowModel, workflowData, parameters);
    }
}

