/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.LocaleWorkflow;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowProcess;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.impl.integration.platform.InboxNotificationService;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClientFactory;
import com.smartling.aem.connector.core.impl.integration.platform.WorkflowApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.WorkflowApiClientFactory;
import com.smartling.api.projects.v2.pto.ProjectDetailsPTO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.smartling.api.internal.workflows.v3.pto.UserWorkflowPTO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WorkflowProcess.class})
public class LocaleWorkflowValidatorProcess
extends ContextAwareWorkflowProcess
implements WorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocaleWorkflowValidatorProcess.class);
    public static final String NO_PROJECT_DETAILS_ERROR_MESSAGE = "Couldn't take project details for projectUid=\"%s\".";
    public static final String LOCALE_WORKFLOW_CHECK_ERROR_MESSAGE = "Couldn't check localeWorkflows=\"%s\".";
    public static final String UNKNOWN_WORKFLOW_ERROR_MESSAGE = "Couldn't find workflow=\"%s\".";
    public static final String LOCALE_WORKFLOW_NO_MATCH_ERROR_MESSAGE = "Couldn't match locales for workflow=\"%s\".";
    public static final String WORKFLOW_DOESNT_SUPPORT_LANGUAGE_ERROR_MESSAGE = "Workflow=\"%s\" doesn't support language=\"%s\".";
    public static final String INVALID_WORKFLOW_PARAMETERS_ERROR_MESSAGE = "Invalid workflow parameters.";
    @Reference
    private WorkflowApiClientFactory workflowApiClientFactory;
    @Reference
    private ProjectApiClientFactory projectApiClientFactory;
    @Reference
    private InboxNotificationService inboxNotificationService;

    @Override
    protected void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        Object errorMessage2;
        ProjectDetailsPTO projectDetails;
        JobWorkflowParameters parameters;
        try {
            parameters = new JobWorkflowParameters(workItem);
        }
        catch (Exception e) {
            this.setError(workItem, workflowSession, null, INVALID_WORKFLOW_PARAMETERS_ERROR_MESSAGE, e);
            throw new WorkflowException(INVALID_WORKFLOW_PARAMETERS_ERROR_MESSAGE, (Throwable)e);
        }
        if (CollectionUtils.isEmpty(parameters.getLocaleWorkflows())) {
            return;
        }
        SmartlingCloudConfig config = this.getSmartlingCloudConfig(workItem, workflowSession);
        try (ProjectApiClient client = this.projectApiClientFactory.createClient(config);){
            projectDetails = client.getProjectDetails();
        }
        catch (Exception e) {
            String errorMessage2 = String.format(NO_PROJECT_DETAILS_ERROR_MESSAGE, parameters.getProjectUid());
            this.setError(workItem, workflowSession, parameters, errorMessage2, e);
            throw new WorkflowException(errorMessage2, (Throwable)e);
        }
        try {
            WorkflowApiClient workflowApiClient = this.workflowApiClientFactory.createClient(config);
            errorMessage2 = null;
            try {
                for (LocaleWorkflow localeWorkflow : parameters.getLocaleWorkflows()) {
                    List<UserWorkflowPTO> workflowConfig = workflowApiClient.getUserAllowedWorkflows(projectDetails.getAccountUid(), Collections.singletonList(localeWorkflow.getWorkflowUid()));
                    if (CollectionUtils.isEmpty(workflowConfig) || !StringUtils.equalsIgnoreCase((CharSequence)workflowConfig.get(0).getWorkflowUid(), (CharSequence)localeWorkflow.getWorkflowUid())) {
                        String errorMessage3 = String.format(UNKNOWN_WORKFLOW_ERROR_MESSAGE, localeWorkflow.getWorkflowUid());
                        throw new WorkflowException(errorMessage3);
                    }
                    List localePairs = workflowConfig.get(0).getLocalePairs();
                    if (CollectionUtils.isEmpty((Collection)localePairs)) {
                        String errorMessage4 = String.format(LOCALE_WORKFLOW_NO_MATCH_ERROR_MESSAGE, localeWorkflow.getWorkflowUid());
                        throw new WorkflowException(errorMessage4);
                    }
                    boolean workflowHasTargetLanguage = localePairs.stream().flatMap(localePair -> localePair.getTargetLocaleIds().stream()).anyMatch(workflowTargetLocale -> StringUtils.equalsIgnoreCase((CharSequence)workflowTargetLocale, (CharSequence)localeWorkflow.getTargetLocale()));
                    if (workflowHasTargetLanguage) continue;
                    String errorMessage5 = String.format(WORKFLOW_DOESNT_SUPPORT_LANGUAGE_ERROR_MESSAGE, localeWorkflow.getWorkflowUid(), localeWorkflow.getTargetLocale());
                    throw new WorkflowException(errorMessage5);
                }
            }
            catch (Throwable throwable) {
                errorMessage2 = throwable;
                throw throwable;
            }
            finally {
                if (workflowApiClient != null) {
                    if (errorMessage2 != null) {
                        try {
                            workflowApiClient.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)errorMessage2).addSuppressed(throwable);
                        }
                    } else {
                        workflowApiClient.close();
                    }
                }
            }
        }
        catch (Exception e) {
            errorMessage2 = String.format(LOCALE_WORKFLOW_CHECK_ERROR_MESSAGE, parameters.getLocaleWorkflows().stream().map(LocaleWorkflow::toString).collect(Collectors.joining(",")));
            errorMessage2 = (String)errorMessage2 + " " + e.getMessage();
            this.setError(workItem, workflowSession, parameters, (String)errorMessage2, e);
            throw new WorkflowException((String)errorMessage2);
        }
    }

    private void setError(WorkItem workItem, WorkflowSession workflowSession, JobWorkflowParameters parameters, String message, Exception e) throws WorkflowException {
        String errorMessage = this.getErrorMessage(workItem) + " Your content is not submitted to Smartling. " + message;
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        if (parameters != null) {
            String sourcePaths = StringUtils.join(parameters.getSourcePathList(), (String)";");
            this.inboxNotificationService.sendNotification(resourceResolver, "Smartling: Content was not submitted", errorMessage, sourcePaths);
        }
        LOGGER.error(errorMessage, (Throwable)e);
        this.setErrorMessage(workItem, errorMessage);
        this.terminate(workItem, workflowSession);
    }
}

