/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowExternalProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.TranslationProjectManager;
import com.smartling.aem.connector.automation.impl.wcm.workflow.TranslationWorkflow;
import com.smartling.aem.connector.automation.impl.wcm.workflow.TranslationWorkflowManager;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowExternalProcess;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WorkflowExternalProcess.class})
public class ProjectCustomizationProcess
extends ContextAwareWorkflowExternalProcess
implements WorkflowExternalProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectCustomizationProcess.class);
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private TranslationProjectManager translationProjectManager;
    @Reference
    private TranslationWorkflowManager translationWorkflowManager;

    @Override
    public Serializable executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        return UUID.randomUUID();
    }

    @Override
    public boolean hasFinishedInternal(Serializable key, WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) {
        LOGGER.trace("Checking if the translation project was created and customizing it.");
        if (WorkflowUtil.isWorkflowAborted(workItem)) {
            LOGGER.debug("Stop waiting for project to be created: the workflow has been aborted");
            return true;
        }
        if (this.getMinutesAfterStartProcess(workItem) > (long)this.translationProjectManager.getPollingUploadComplete()) {
            LOGGER.warn("Couldn't customize translation project because polling period is exceeded.");
            return true;
        }
        String projectFolderPath = StringUtils.substringBeforeLast((String)ProjectCustomizationProcess.getProjectPath(workItem), (String)"/");
        if (this.areAemWorkflowsFailed(projectFolderPath)) {
            return true;
        }
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        Resource projectFolderPathResource = resourceResolver.getResource(projectFolderPath);
        if (projectFolderPathResource == null) {
            LOGGER.error("Couldn't process a translation project because folder=\"{}\" haven't been created yet.", (Object)projectFolderPath);
            return false;
        }
        boolean empty = true;
        for (Resource projectResource : projectFolderPathResource.getChildren()) {
            empty = false;
            String projectPath = projectResource.getPath();
            boolean completed = this.translationProjectManager.applyProjectCustomizations(resourceResolver, projectPath);
            if (completed) continue;
            return false;
        }
        if (empty) {
            LOGGER.warn("No translation projects found in folder=\"{}\".", (Object)projectFolderPath);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areAemWorkflowsFailed(String projectPath) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.emptyMap());
            List<TranslationWorkflow> workflows = this.translationWorkflowManager.getAEMTranslationWorkflows(projectPath, resourceResolver);
            for (TranslationWorkflow workflow : workflows) {
                if (!StringUtils.isNotBlank((CharSequence)workflow.getFailureMessage())) continue;
                LOGGER.error("AEM workflowPath=\"{}\" has been failed with message=\"{}\" and stacktrace=\"{}\"", new Object[]{workflow.getPath(), workflow.getFailureMessage(), workflow.getFailureStack()});
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to check AEM Workflows for projectPath={}", (Object)projectPath, (Object)e);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
        return false;
    }

    @Override
    public void handleResultInternal(Serializable key, WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
    }

    private static String getProjectPath(WorkItem workItem) {
        return (String)workItem.getWorkflowData().getMetaDataMap().get("project", (Object)"");
    }

    private long getMinutesAfterStartProcess(WorkItem workItem) {
        Long startTime = (Long)workItem.getWorkflowData().getMetaDataMap().get("startTime", Long.class);
        if (startTime == null) {
            startTime = this.restoreMinutesAfterStartProcess(workItem);
        }
        return (System.currentTimeMillis() - startTime) / 60000L;
    }

    private long restoreMinutesAfterStartProcess(WorkItem workItem) {
        LOGGER.warn("It seems ProjectCustomizationProcess was called before SendForTranslationExternalProcess for projectPaths=\"{}\"", (Object)ProjectCustomizationProcess.getProjectPath(workItem));
        long startTime = System.currentTimeMillis();
        workItem.getWorkflowData().getMetaDataMap().put((Object)"startTime", (Object)startTime);
        return startTime;
    }
}

