/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowProcess;
import com.smartling.aem.connector.core.impl.integration.platform.InboxNotificationService;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WorkflowProcess.class})
public class TargetLocalesValidatorProcess
extends ContextAwareWorkflowProcess
implements WorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(TargetLocalesValidatorProcess.class);
    public static final String NO_TARGET_LOCALES_ERROR_MESSAGE = "Could not proceed with workflow. No target locales are specified.";
    @Reference
    private InboxNotificationService inboxNotificationService;

    @Override
    public void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        JobWorkflowParameters parameters;
        try {
            parameters = new JobWorkflowParameters(workItem);
        }
        catch (Exception e) {
            this.setError(workItem, workflowSession, null, "Invalid workflow parameters.", e);
            throw new WorkflowException("Invalid workflow parameters.", (Throwable)e);
        }
        if (parameters.getTargetLocaleCodes().isEmpty()) {
            this.setError(workItem, workflowSession, parameters, NO_TARGET_LOCALES_ERROR_MESSAGE, null);
            throw new WorkflowException(NO_TARGET_LOCALES_ERROR_MESSAGE);
        }
    }

    @Override
    protected boolean shouldExecute(WorkItem workItem) {
        return this.isExecutedFirstTime(workItem);
    }

    private void setError(WorkItem workItem, WorkflowSession workflowSession, JobWorkflowParameters parameters, String message, Exception e) throws WorkflowException {
        String errorMessage = this.getErrorMessage(workItem) + " Your content was not submitted to Smartling. " + message;
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        if (parameters != null) {
            String sourcePaths = StringUtils.join(parameters.getSourcePathList(), (String)";");
            this.inboxNotificationService.sendNotification(resourceResolver, "Smartling: Content was not submitted", errorMessage, sourcePaths);
        }
        if (e != null) {
            LOGGER.error(errorMessage, (Throwable)e);
        } else {
            LOGGER.error(errorMessage);
        }
        this.setErrorMessage(workItem, errorMessage);
        this.terminate(workItem, workflowSession);
    }
}

