/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow.context;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.Workflow;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.CloudConfigLocator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class ContextAwareGenericProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextAwareGenericProcess.class);
    private static final String PROJECT_ID = "projectId";
    @Reference
    protected CloudConfigLocator cloudConfigLocator;

    ContextAwareGenericProcess() {
    }

    void clearMDC() {
        MDC.remove((String)PROJECT_ID);
    }

    void injectMDC(WorkItem workItem, WorkflowSession workflowSession) {
        try {
            SmartlingCloudConfig config = this.getSmartlingCloudConfig(workItem, workflowSession);
            if (config != null) {
                MDC.put((String)PROJECT_ID, (String)config.getProjectId());
            }
        }
        catch (Exception e) {
            LOGGER.error("Can't init MDC for {}", this.getClass(), (Object)e);
        }
    }

    protected final boolean isExecutedFirstTime(WorkItem workItem) {
        return (Boolean)workItem.getWorkflowData().getMetaDataMap().get(workItem.getNode().getTitle() + "_executed", (Object)false) == false;
    }

    protected final void markStepAsExecuted(WorkItem workItem) {
        workItem.getWorkflowData().getMetaDataMap().put((Object)(workItem.getNode().getTitle() + "_executed"), (Object)true);
    }

    protected boolean shouldExecute(WorkItem workItem) {
        if (!this.isExecutedFirstTime(workItem)) {
            LOGGER.trace("\"{}\" has already been executed.", (Object)workItem.getNode().getTitle());
            return false;
        }
        if (this.hasErrorMessage(workItem)) {
            LOGGER.trace("\"{}\" shouldn't be executed because of error.", (Object)workItem.getNode().getTitle());
            return false;
        }
        return true;
    }

    protected boolean hasErrorMessage(WorkItem workItem) {
        return StringUtils.isNotEmpty((CharSequence)this.getErrorMessage(workItem));
    }

    protected final void setErrorMessage(WorkItem workItem, String message) {
        workItem.getWorkflowData().getMetaDataMap().put((Object)"errorMessage", (Object)message);
    }

    public final String getErrorMessage(WorkItem workItem) {
        return (String)workItem.getWorkflowData().getMetaDataMap().get("errorMessage", (Object)"");
    }

    protected final void setInfoMessage(WorkItem workItem, String message) {
        workItem.getWorkflowData().getMetaDataMap().put((Object)"infoMessage", (Object)message);
    }

    public final String getInfoMessage(WorkItem workItem) {
        return (String)workItem.getWorkflowData().getMetaDataMap().get("infoMessage", String.class);
    }

    protected SmartlingCloudConfig getSmartlingCloudConfig(WorkItem workItem, WorkflowSession workflowSession) throws WorkflowException {
        Resource resource = this.getPayloadResource(workItem, workflowSession);
        SmartlingCloudConfig cloudConfig = this.cloudConfigLocator.getCloudConfigAppliedOnResource(resource, SmartlingCloudConfig.class);
        MetaDataMap workflowMetadata = workItem.getWorkflowData().getMetaDataMap();
        String projectUid = (String)workflowMetadata.get("projectUid", (Object)"");
        String configSourceLocaleCode = (String)workflowMetadata.get("configSourceLocaleCode", (Object)"");
        if (cloudConfig == null) {
            throw new WorkflowException("No Smartling cloud config found for a content");
        }
        return StringUtils.isNotBlank((CharSequence)projectUid) ? cloudConfig.getForProject(projectUid) : cloudConfig.getForLocale(configSourceLocaleCode);
    }

    protected Resource getPayloadResource(WorkItem workItem, WorkflowSession workflowSession) {
        String payloadPagePath = (String)workItem.getWorkflowData().getPayload();
        return ((ResourceResolver)workflowSession.adaptTo(ResourceResolver.class)).resolve(payloadPagePath);
    }

    protected void logMetaDataMap(WorkItem workItem) {
        MetaDataMap metaDataMap = workItem.getWorkflowData().getMetaDataMap();
        String metadataMapToString = metaDataMap.entrySet().stream().map(entry -> entry.getValue().getClass().isArray() ? String.format("%s=\"%s\"", entry.getKey(), ArrayUtils.toString(entry.getValue())) : String.format("%s=\"%s\"", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        LOGGER.error("MetaDataMap: [{}] {}", (Object)metaDataMap.hashCode(), (Object)metadataMapToString);
    }

    protected void terminate(WorkItem workItem, WorkflowSession workflowSession) throws WorkflowException {
        Workflow workflow = workflowSession.getWorkflow(workItem.getWorkflow().getId());
        workflowSession.terminateWorkflow(workflow);
    }
}

