/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow.context;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowExternalProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareGenericProcess;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextAwareWorkflowExternalProcess
extends ContextAwareGenericProcess
implements WorkflowExternalProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextAwareWorkflowExternalProcess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Serializable execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        try {
            this.injectMDC(workItem, workflowSession);
            UUID uUID = this.shouldExecute(workItem) ? this.executeInternal(workItem, workflowSession, metaDataMap) : UUID.randomUUID();
            return uUID;
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasFinished(Serializable serializable, WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) {
        try {
            this.injectMDC(workItem, workflowSession);
            boolean bl = !this.shouldExecute(workItem) || this.hasFinishedInternal(serializable, workItem, workflowSession, metaDataMap);
            return bl;
        }
        finally {
            this.clearMDC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleResult(Serializable serializable, WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        try {
            this.injectMDC(workItem, workflowSession);
            if (this.shouldExecute(workItem)) {
                this.handleResultInternal(serializable, workItem, workflowSession, metaDataMap);
            } else {
                LOGGER.warn("workflow={} step={} skipped", (Object)workItem.getId(), this.getClass());
                this.logMetaDataMap(workItem);
            }
        }
        catch (Exception e) {
            String message = String.format("Error occurred while submitting content: step=%s failed with message=%s", this.getClass(), e.getMessage());
            this.setErrorMessage(workItem, message);
            LOGGER.error(message, (Throwable)e);
        }
        finally {
            this.clearMDC();
            this.markStepAsExecuted(workItem);
        }
    }

    protected abstract Serializable executeInternal(WorkItem var1, WorkflowSession var2, MetaDataMap var3) throws WorkflowException;

    protected abstract boolean hasFinishedInternal(Serializable var1, WorkItem var2, WorkflowSession var3, MetaDataMap var4);

    protected abstract void handleResultInternal(Serializable var1, WorkItem var2, WorkflowSession var3, MetaDataMap var4) throws WorkflowException;
}

