/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.smartling.aem.connector.automation.CloudConfigLocator;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.impl.integration.platform.Job;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClientFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/jobs"})
public class ListEditableJobsServlet
extends SmartlingBaseServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListEditableJobsServlet.class);
    @Reference
    private JobApiClientFactory clientFactory;
    @Reference
    private CloudConfigLocator cloudConfigLocator;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String path = request.getParameter("path");
        if (StringUtils.isEmpty((CharSequence)path)) {
            response.sendError(400, "Mandatory path parameter is missing");
            return;
        }
        Resource resource = resourceResolver.resolve(StringUtils.substringBefore((String)path, (String)";"));
        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
            response.sendError(400, "Page can not be found");
            return;
        }
        String projectUid = request.getParameter("projectUid");
        List<Job> jobs = this.loadJobsAvailableForResource(resource, projectUid);
        List sortedJobs = jobs.stream().sorted(new Comparator<Job>(){

            @Override
            public int compare(Job o1, Job o2) {
                return o2.getCreatedDate().compareTo(o1.getCreatedDate());
            }
        }).collect(Collectors.toList());
        ListEditableJobsServlet.writeJson(response, sortedJobs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Job> loadJobsAvailableForResource(@Nonnull Resource resource, String projectUid) throws ServletException {
        SmartlingCloudConfig cloudConfig = this.cloudConfigLocator.getCloudConfigAppliedOnResource(resource, SmartlingCloudConfig.class);
        if (cloudConfig == null) return Collections.emptyList();
        cloudConfig = this.cloudConfigResolver.getConfigByResource(cloudConfig, resource, projectUid);
        try (JobApiClient client = this.clientFactory.createClient(cloudConfig);){
            List<Job> list = client.listJobsByState(Arrays.asList(Job.State.AWAITING_AUTHORIZATION, Job.State.IN_PROGRESS, Job.State.COMPLETED));
            return list;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

