/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={SmartlingDialogConfiguration.class})
@Designate(ocd=Config.class)
public class SmartlingDialogConfiguration {
    public static final boolean RESPECT_CONTENT_OBSERVING_LANGUAGE_ROOTS_DEFAULT = true;
    public static final String RESPECT_CONTENT_OBSERVING_LANGUAGE_ROOTS = "respect.content.observing.language.roots";
    public static final boolean LANGUAGE_ROOT_SIBLINGS_ONLY_DEFAULT = false;
    public static final String LANGUAGE_ROOT_SIBLINGS_ONLY = "only.sibling.language.roots";
    private static final boolean ENABLE_LEGACY_CONFIG_VALIDATION_DEFAULT_VALUE = true;
    private static final boolean ENABLE_TARGET_CONTENT_EXISTENCE_VALIDATION_DEFAULT_VALUE = false;
    private static final boolean PSEUDO_TRANSLATION_OPTION_DEFAULT_VALUE = false;
    private static final boolean CHECK_DAM_FOLDER_DESCENDANTS_OPTION_DEFAULT_VALUE = false;
    private boolean respectContent = true;
    private boolean languageRootSiblingsOnly = false;
    private boolean legacyConfigValidationEnable = true;
    private boolean targetContentExistenceValidationEnable = false;
    private boolean pseudoTranslationDefault = false;
    private boolean checkDamFolderDescendants = false;

    @Activate
    public void activate(Config config) {
        this.respectContent = config.respect_content_observing_language_roots();
        this.languageRootSiblingsOnly = config.only_sibling_language_roots();
        this.legacyConfigValidationEnable = config.translation_project_enable_legacy_config_validation();
        this.targetContentExistenceValidationEnable = config.target_content_existence_validation();
        this.pseudoTranslationDefault = config.translation_pseudo_default();
        this.checkDamFolderDescendants = config.check_dam_folder_descendants();
    }

    public boolean areLanguageRootSiblingsOnly() {
        return this.languageRootSiblingsOnly;
    }

    public boolean respectContent() {
        return this.respectContent;
    }

    public boolean isLegacyConfigValidationEnabled() {
        return this.legacyConfigValidationEnable;
    }

    public boolean isTargetContentExistenceValidationEnabled() {
        return this.targetContentExistenceValidationEnable;
    }

    public boolean isPseudoTranslationEnabledByDefault() {
        return this.pseudoTranslationDefault;
    }

    public boolean isCheckDamFolderDescendantsOption() {
        return this.checkDamFolderDescendants;
    }

    @ObjectClassDefinition(name="Smartling - Dialog configuration (Touch)", description="Set of configuration options of Smartling Request Translation dialog.")
    public static @interface Config {
        @AttributeDefinition(name="Include language root pages", description="Forces AEM to search for language roots (cq:isLanguageRoot) with defined Language (jcr:language) of a page")
        public boolean respect_content_observing_language_roots() default true;

        @AttributeDefinition(name="Only sibling language roots", description="This causes the Smartling dialog to not displaying language roots from other levels.")
        public boolean only_sibling_language_roots() default false;

        @AttributeDefinition(name="Enable Legacy Config Validation", description="Enables / Disables validation of legacy AEM Cloud service configuration.")
        public boolean translation_project_enable_legacy_config_validation() default true;

        @AttributeDefinition(name="Enable Target Content Existence Validation", description="Don't allow translation request if the page doesn't exist in selected language(s).")
        public boolean target_content_existence_validation() default false;

        @AttributeDefinition(name="Pseudo Translation Default", description="Provide Smartling Dialog with default value for Pseudo-Translation option.")
        public boolean translation_pseudo_default() default false;

        @AttributeDefinition(name="Check DAM folder descendants", description="Causes Smartling Dialog to check descendants of selected DAM folder instead of checking just children.")
        public boolean check_dam_folder_descendants() default false;
    }
}

