/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.adobe.granite.workflow.WorkflowException;
import com.smartling.aem.connector.automation.impl.FormLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.TranslationRequest;
import com.smartling.aem.connector.automation.ui.SmartlingJobWorkflowServlet;
import com.smartling.aem.connector.automation.ui.SmartlingJobWorkflowServletValidator;
import com.smartling.aem.connector.automation.ui.SmartlingValidationException;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.paths=/services/smartling/job/workflows/form"})
public class SmartlingJobWorkflowFormServlet
extends SmartlingJobWorkflowServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingJobWorkflowFormServlet.class);
    @Reference
    private SmartlingJobWorkflowServletValidator validator;
    @Reference
    private FormLanguageCopyManager languageCopyManager;

    @Override
    protected void doPostInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        TranslationRequest translationRequest = this.getTranslationRequestBuilder(request);
        String path = translationRequest.getPaths()[0];
        SmartlingCloudConfig cloudConfig = this.getSmartlingConfig(resourceResolver, path, translationRequest.getProjectUid());
        String sourceLocaleCode = this.languageCopyManager.getLanguage(resourceResolver, path).getCode();
        translationRequest.setSourceLocaleCode(sourceLocaleCode);
        try {
            this.validator.validateConfig(request, resourceResolver);
        }
        catch (SmartlingValidationException e) {
            LOGGER.warn("Validation failed. Failed to create/update job [jobName={}, jobUid={}]:", new Object[]{translationRequest.getJobName(), translationRequest.getJobUid(), e});
            throw new ServletException((Throwable)e);
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed to validate configuration", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        try {
            Map<String, Object> metadata = this.prepareMetadata(request, resourceResolver, translationRequest);
            metadata.put("configSourceLocaleCode", sourceLocaleCode);
            this.startWorkflow(resourceResolver, path, "/etc/workflow/models/smartling/form-translate/jcr:content/model", metadata);
            this.logTranslationRequest(translationRequest, cloudConfig);
        }
        catch (WorkflowException | SmartlingException e) {
            LOGGER.error("Failed to start Job Workflow for forms {}:", (Object)translationRequest.getPaths(), (Object)e);
            throw new ServletException(e);
        }
    }
}

