/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.debug;

import com.smartling.aem.connector.automation.CloudConfigLocator;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.debug.dto.SmartlingConfigDTO;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/debug/config"})
public class ConfigCheckingServlet
extends SmartlingBaseServlet {
    @Reference
    private CloudConfigLocator cloudConfigLocator;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String configPath = ConfigCheckingServlet.getMandatoryParameter(request, "path", "Mandatory config \"path\" parameter is missing");
        try {
            SmartlingCloudConfig cloudConfig = this.cloudConfigLocator.getCloudConfig(configPath, SmartlingCloudConfig.class);
            if (cloudConfig == null) {
                response.sendError(404, String.format("Couldn't load config for path=\"%s\"", configPath));
                return;
            }
            SmartlingConfigDTO configDTO = this.convert(cloudConfig);
            ConfigCheckingServlet.writeJson(response, configDTO);
        }
        catch (Exception e) {
            response.sendError(400, e.getMessage());
        }
    }

    private SmartlingConfigDTO convert(SmartlingCloudConfig config) {
        return SmartlingConfigDTO.builder().projectId(config.getProjectId()).path(config.getPath()).mappings(config.getLanguageMapping()).subConfigs(config.getLocaleProjectConfigs().stream().map(cred -> this.convertSubconfig(config.getForLocale(cred.getLocale()), cred.getLocale())).collect(Collectors.toList())).build();
    }

    private SmartlingConfigDTO convertSubconfig(SmartlingCloudConfig config, String locale) {
        return SmartlingConfigDTO.builder().locale(locale).projectId(config.getProjectId()).path(config.getPath()).mappings(config.getLanguageMapping()).build();
    }
}

