/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.debug;

import com.day.cq.wcm.api.LanguageManager;
import com.google.gson.Gson;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/debug/page-cq-language"})
public class CqPageLanguageServlet
extends SlingAllMethodsServlet {
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private PageLanguageCopyManager languageCopyManager;
    @Reference
    private LanguageManager languageManager;

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());
            String path = CqPageLanguageServlet.getMandatoryParameter(request, "path", "Mandatory \"path\" parameter is missing");
            Iterable<LanguageCopyManager.LanguageCopy> languageCopies = this.languageCopyManager.findLanguageCopies(resourceResolver, path);
            List<LanguageCopyInfo> languageCopyInfoList = StreamSupport.stream(languageCopies.spliterator(), false).filter(LanguageCopyManager.LanguageCopy::exists).map(copy -> new LanguageCopyInfo(copy.getPath(), copy.getLanguage().getCode())).collect(Collectors.toList());
            ResourceResolver finalResourceResolver = resourceResolver;
            languageCopyInfoList.forEach(languageCopyInfo -> {
                Resource resource = finalResourceResolver.getResource(languageCopyInfo.getPath());
                String cqLanguage = this.languageCopyManager.getCqLanguage(resource);
                languageCopyInfo.setCqLanguage(cqLanguage);
            });
            CqPageLanguageServlet.writeJson(response, languageCopyInfoList);
        }
        catch (IllegalArgumentException e) {
            response.sendError(400, e.getMessage());
        }
        catch (LoginException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
    }

    private static String getMandatoryParameter(@Nonnull SlingHttpServletRequest request, String name, String errorMessage) {
        String value = request.getParameter(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    private static void writeJson(@Nonnull SlingHttpServletResponse response, @Nonnull Object data) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        new Gson().toJson(data, (Appendable)response.getWriter());
    }

    static class LanguageCopyInfo {
        private final String path;
        private final String language;
        private String cqLanguage;

        public LanguageCopyInfo(String path, String language) {
            this.path = path;
            this.language = language;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getPath() {
            return this.path;
        }

        public String getCqLanguage() {
            return this.cqLanguage;
        }

        public void setCqLanguage(String cqLanguage) {
            this.cqLanguage = cqLanguage;
        }
    }
}

