/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.debug;

import com.adobe.cq.launches.api.Launch;
import com.adobe.cq.launches.api.LaunchManager;
import com.adobe.cq.launches.api.LaunchManagerFactory;
import com.google.gson.Gson;
import com.smartling.aem.connector.automation.impl.TranslationUtils;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/debug/launch-master-page"})
public class LaunchMasterPageServlet
extends SlingAllMethodsServlet {
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private LaunchManagerFactory launchesManagerFactory;

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());
            String launchPath = LaunchMasterPageServlet.getMandatoryParameter(request, "launchPath", "Mandatory launchPath parameter is missing");
            String masterLanguage = LaunchMasterPageServlet.getMandatoryParameter(request, "sourceLanguage", "Mandatory sourceLanguage parameter is missing");
            LaunchManager launchManager = this.launchesManagerFactory.getLaunchManager(resourceResolver);
            Launch launch = launchManager.getLaunch(launchPath);
            Resource launchSourceRootRes = launch.getSourceRootResource();
            String launchSrcRootPath = launchSourceRootRes.getPath();
            String launchLangRootPath = TranslationUtils.getLanguageRoot(launchSrcRootPath, resourceResolver);
            String pagePath = launchLangRootPath.equals(launchSrcRootPath) ? "" : '/' + launchSrcRootPath.substring(launchLangRootPath.length() + 1);
            String masterPageRootPath = TranslationUtils.getDestinationLanguageRoot(launchLangRootPath, masterLanguage, resourceResolver);
            String masterPagePath = masterPageRootPath + pagePath;
            String launchRootPath = launchPath + launchLangRootPath;
            Resource masterPageResource = resourceResolver.getResource(masterPagePath);
            InjectInfo info = new InjectInfo(launchSrcRootPath, launchLangRootPath, pagePath, masterPageRootPath, masterPagePath, launchRootPath, masterPageResource != null);
            LaunchMasterPageServlet.writeJson(response, info);
        }
        catch (IllegalArgumentException e) {
            response.sendError(400, e.getMessage());
        }
        catch (RepositoryException | LoginException e) {
            throw new ServletException(e);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
    }

    private static String getMandatoryParameter(@Nonnull SlingHttpServletRequest request, String name, String errorMessage) {
        String value = request.getParameter(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    private static void writeJson(@Nonnull SlingHttpServletResponse response, @Nonnull Object data) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        new Gson().toJson(data, (Appendable)response.getWriter());
    }

    class InjectInfo {
        String launchSrcRootPath;
        String launchLangRootPath;
        String pagePath;
        String masterPageRootPath;
        String masterPagePath;
        String launchRootPath;
        boolean masterPageExists;

        public InjectInfo(String launchSrcRootPath, String launchLangRootPath, String pagePath, String masterPageRootPath, String masterPagePath, String launchRootPath, boolean masterPageExists) {
            this.launchSrcRootPath = launchSrcRootPath;
            this.launchLangRootPath = launchLangRootPath;
            this.pagePath = pagePath;
            this.masterPageRootPath = masterPageRootPath;
            this.masterPagePath = masterPagePath;
            this.launchRootPath = launchRootPath;
            this.masterPageExists = masterPageExists;
        }
    }
}

