/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.debug;

import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.core.ConfigurationManager;
import com.smartling.aem.connector.core.SmartlingCredentials;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClientFactory;
import com.smartling.aem.connector.core.impl.integration.platform.WorkflowApiClientFactory;
import com.smartling.api.projects.v2.pto.ProjectDetailsPTO;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import net.smartling.api.internal.workflows.v3.pto.UserWorkflowPTO;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/debug/workflows"})
public class ListWorkflowsServlet
extends SmartlingBaseServlet {
    @Reference
    private ConfigurationManager configurationManager;
    @Reference
    private WorkflowApiClientFactory workflowApiClientFactory;
    @Reference
    private ProjectApiClientFactory projectApiClientFactory;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        Object message3;
        ProjectDetailsPTO projectDetails;
        AutoCloseable client;
        String projectUid = ListWorkflowsServlet.getMandatoryParameter(request, "projectUid", "Mandatory projectUid parameter is missing");
        Optional<SmartlingCredentials> creds = this.configurationManager.getConfigurations().stream().filter(config -> StringUtils.equalsIgnoreCase((CharSequence)projectUid, (CharSequence)config.getProjectId())).findFirst();
        if (!creds.isPresent()) {
            String message2 = String.format("Couldn't get project configuration for projectUid=\"%s\"", projectUid);
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, message2);
            return;
        }
        try {
            client = this.projectApiClientFactory.createClient(creds.get());
            Throwable throwable = null;
            try {
                projectDetails = client.getProjectDetails();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (client != null) {
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (Exception e) {
            String message3 = String.format("Couldn't get project details for projectUid=\"%s\"", projectUid);
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, message3);
            return;
        }
        try {
            client = this.workflowApiClientFactory.createClient(creds.get());
            message3 = null;
            try {
                List<UserWorkflowPTO> workflows = client.getUserAllowedWorkflows(projectDetails.getAccountUid(), null);
                ListWorkflowsServlet.writeJson(response, workflows);
            }
            catch (Throwable throwable) {
                message3 = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (message3 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)message3).addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (Exception e) {
            message3 = String.format("Couldn't get workflows for projectUid=\"%s\"", projectUid);
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, (String)message3);
        }
    }
}

