/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.config;

import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.config.CloudConfigChildPageValidator;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/cloud/config/childpage/validator"})
public class CloudConfigChildPageValidatorServlet
extends SmartlingBaseServlet {
    @Reference
    private CloudConfigChildPageValidator cloudConfigChildPageValidator;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String payloadPath = this.servletUtils.getPayloadPath(request);
        boolean isDeep = Boolean.parseBoolean(request.getParameter("isDeep"));
        if (!isDeep) {
            return;
        }
        for (String path : StringUtils.split((String)payloadPath, (String)";")) {
            try {
                this.cloudConfigChildPageValidator.validate(resourceResolver, path);
            }
            catch (SmartlingException e) {
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
                return;
            }
        }
    }
}

