/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.locale;

import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.FormLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SourceLocaleValidator.class})
public class SourceLocaleValidator {
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;
    @Reference
    private FormLanguageCopyManager formLanguageCopyManager;

    public String validate(ResourceResolver resourceResolver, SmartlingCloudConfig cloudConfig, String sourcePath) throws SmartlingException {
        LanguageCopyManager languageCopyManager = StringUtils.startsWithIgnoreCase((CharSequence)sourcePath, (CharSequence)"/content/dam") ? this.assetLanguageCopyManager : (StringUtils.startsWithIgnoreCase((CharSequence)sourcePath, (CharSequence)"/content/forms") ? this.formLanguageCopyManager : this.pageLanguageCopyManager);
        Language language = languageCopyManager.getLanguage(resourceResolver, sourcePath);
        if (language == null) {
            throw new SmartlingException(String.format("Couldn't find source locale for path=\"%s\"", sourcePath));
        }
        String mappedLocale = cloudConfig.getLanguageMapping().get(language.getCode());
        if (StringUtils.isBlank((CharSequence)mappedLocale)) {
            throw new SmartlingException(String.format("There is no mapping for locale=\"%s\"", language.getCode()));
        }
        return language.getCode();
    }
}

