/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.provider;

import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.provider.MachineTranslationMethodValidator;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/machine/translation/method/validator"})
public class MachineTranslationMethodValidatorServlet
extends SmartlingBaseServlet {
    public static final String NO_RESOURCE_ERROR_MESSAGE = "There is no resource";
    @Reference
    private MachineTranslationMethodValidator machineTranslationMethodValidator;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String payloadPath = this.servletUtils.getPayloadPath(request);
        if (StringUtils.isBlank((CharSequence)payloadPath)) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 404, NO_RESOURCE_ERROR_MESSAGE);
            return;
        }
        for (String path : StringUtils.split((String)payloadPath, (String)";")) {
            try {
                this.machineTranslationMethodValidator.validate(path, resourceResolver);
            }
            catch (SmartlingException e) {
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
                return;
            }
        }
    }
}

