/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.provider;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.smartling.aem.connector.automation.ui.validator.provider.WrongProviderException;
import com.smartling.aem.connector.core.SmartlingException;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;

@Component(service={TranslationProviderValidator.class})
public class TranslationProviderValidator {
    public static final String DAM_ROOT_FOLDER = "/content/dam";
    public static final String CONTENT_ROOT_FOLDER = "/content";
    public static final String SMARTLING_PROVIDER_NAME = "smartling";

    public void validate(String path, MachineTranslationCloudConfig machineTranslationCloudConfig) throws SmartlingException {
        this.validateTranslationProvider(path, machineTranslationCloudConfig);
    }

    public void validateTranslationProvider(String path, MachineTranslationCloudConfig machineTranslationCloudConfig) throws SmartlingException {
        if (StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)DAM_ROOT_FOLDER)) {
            String providerName;
            MachineTranslationCloudConfig.TranslationProviderWorkflow translationMethod = machineTranslationCloudConfig.getDefaultTranslationProviderWorkflowForAssets();
            String string = providerName = translationMethod == MachineTranslationCloudConfig.TranslationProviderWorkflow.MACHINE_TRANSLATION ? machineTranslationCloudConfig.getDefaultTranslationProviderForAssets() : machineTranslationCloudConfig.getDefaultPostEditProviderForAssets();
            if (!StringUtils.startsWithIgnoreCase((CharSequence)providerName, (CharSequence)SMARTLING_PROVIDER_NAME)) {
                throw new WrongProviderException("Smartling is not specified as a Translation Provider for Assets. Current provider is " + providerName);
            }
        } else if (StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)CONTENT_ROOT_FOLDER)) {
            String providerName;
            MachineTranslationCloudConfig.TranslationProviderWorkflow translationMethod = machineTranslationCloudConfig.getDefaultTranslationProviderWorkflowForSites();
            String string = providerName = translationMethod == MachineTranslationCloudConfig.TranslationProviderWorkflow.MACHINE_TRANSLATION ? machineTranslationCloudConfig.getDefaultTranslationProviderForSites() : machineTranslationCloudConfig.getDefaultPostEditProviderForSites();
            if (!StringUtils.startsWithIgnoreCase((CharSequence)providerName, (CharSequence)SMARTLING_PROVIDER_NAME)) {
                throw new WrongProviderException("Smartling is not specified as a Translation Provider for Sites. Current provider is " + providerName);
            }
        }
    }
}

