/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl;

import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.TranslationStartedEvent;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.aem.connector.core.impl.integration.LocaleNotSupportedException;
import com.smartling.aem.connector.core.impl.integration.TranslationEventBus;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseSmartlingFacade
implements SmartlingFacade {
    @Reference
    protected TranslationEventBus translationEventBus;

    @Override
    public String createTranslationJob(String sourceLanguage, String targetLanguage) throws SmartlingException {
        String jobId = RandomStringUtils.randomAlphanumeric((int)12);
        this.translationEventBus.publish(new TranslationStartedEvent());
        return jobId;
    }

    protected String mapToSmartlingLocaleCode(String localeCode, Map<String, String> availableMappings) throws LocaleNotSupportedException {
        String smartlingSourceLanguageCode = availableMappings.get(localeCode);
        if (smartlingSourceLanguageCode == null) {
            throw new LocaleNotSupportedException(String.format("Couldn't map AEM locale=\"%s\".", localeCode));
        }
        return smartlingSourceLanguageCode;
    }
}

