/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={PseudoContentDownloadManager.class})
@Designate(ocd=Config.class)
public class PseudoContentDownloadManager {
    private boolean removeFile;
    private boolean cancelJob;

    @Activate
    public void activate(Config config) {
        this.removeFile = config.pseudo_download_remove_file();
        this.cancelJob = config.pseudo_download_cancel_job();
    }

    public boolean shouldRemoveFileAfterDownload() {
        return this.removeFile;
    }

    public boolean shouldCancelJobAfterDownload() {
        return this.cancelJob;
    }

    @ObjectClassDefinition(name="Smartling - Pseudo content download manager (Touch)", description="Allows to download pseudo translation for particular locales instantly")
    public static @interface Config {
        @AttributeDefinition(name="Remove a file after delivery", description="Causes connector to remove a file after pseudo translation was already downloaded for them")
        public boolean pseudo_download_remove_file() default true;

        @AttributeDefinition(name="Cancel job files after delivery", description="Causes connector to cancel an empty job (without source files) after pseudo translation was downloaded")
        public boolean pseudo_download_cancel_job() default true;
    }
}

