/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={CallbackUriProviderConfig.class}, immediate=true)
@Designate(ocd=Config.class)
public class CallbackUriProviderConfig {
    private String callbackUrl;
    private String callbackSharedSecret;

    @Activate
    protected void activate(Config config) {
        this.callbackUrl = (String)StringUtils.defaultIfEmpty((CharSequence)config.callback_url(), null);
        String callbackHostUrl = (String)StringUtils.defaultIfEmpty((CharSequence)config.callback_host_url(), null);
        this.callbackSharedSecret = (String)StringUtils.defaultIfEmpty((CharSequence)config.callback_shared_secret(), null);
        if (StringUtils.isNotBlank((CharSequence)this.callbackUrl)) {
            this.callbackUrl = StringUtils.trim((String)this.callbackUrl);
        } else if (StringUtils.isNotBlank((CharSequence)callbackHostUrl)) {
            callbackHostUrl = StringUtils.trim((String)callbackHostUrl);
            callbackHostUrl = StringUtils.removeEnd((String)callbackHostUrl, (String)"/");
            this.callbackUrl = callbackHostUrl + "/services/smartling/sync-translation";
        }
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getCallbackSharedSecret() {
        return this.callbackSharedSecret;
    }

    @ObjectClassDefinition(name="Smartling - Callback URL (Touch)", description="A callback URL can be sent to Smartling on file upload. When a file is complete, Smartling will notify the URL. Smartling's Touch Connector do handle callback URL for sync translation from Smartling to AEM.")
    public static @interface Config {
        @AttributeDefinition(name="Callback URL", description="If empty, the callback will be not set for the file. Callback URL must be a valid URL (e.g. https://domain.com/services/smartling/sync-translation) which can be reached from the Internet. If the URL is malformed then file upload will fail.")
        public String callback_url() default "";

        @AttributeDefinition(name="Callback shared secret", description="If empty, the connector doesn't validate the authenticity of the callback request.", type=AttributeType.PASSWORD)
        public String callback_shared_secret() default "";

        @AttributeDefinition(name="Callback host URL")
        public String callback_host_url() default "";
    }
}

