/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingCredentials;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.SmartlingProjectLocaleCredentials;
import com.smartling.aem.connector.core.impl.config.BaseSmartlingCloudConfig;
import com.smartling.aem.connector.core.impl.config.SmartlingProjectCredentials;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClientFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JcrSmartlingCloudConfig
extends BaseSmartlingCloudConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrSmartlingCloudConfig.class);
    private final Gson GSON = new GsonBuilder().create();
    private final CryptoSupport cryptoSupport;
    private final String path;
    private final String projectId;
    private final String userIdentifier;
    private final String tokenSecret;
    private final Map<String, SmartlingCredentials> smartlingCredentials = new TreeMap<String, SmartlingCredentials>(new AEMLocaleComparator());

    JcrSmartlingCloudConfig(Resource configResource, CryptoSupport cryptoSupport, ProjectApiClientFactory projectApiClientFactory) {
        super(projectApiClientFactory, configResource.getResourceResolver());
        this.cryptoSupport = cryptoSupport;
        this.path = configResource.getParent().getPath();
        ValueMap properties = configResource.getValueMap();
        this.projectId = (String)properties.get("projectId", String.class);
        this.userIdentifier = (String)properties.get("userIdentifier", String.class);
        this.tokenSecret = (String)properties.get("tokenSecret", String.class);
        String smartlingCredentialStr = (String)properties.get("multiLocaleConfig", String.class);
        this.initSmartlingCredentials(smartlingCredentialStr);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    @Override
    public String getTokenSecret() {
        try {
            return this.cryptoSupport.unprotect(this.tokenSecret);
        }
        catch (CryptoException e) {
            throw new IllegalStateException("Failed to decrypt a token secret", e);
        }
    }

    @Override
    public boolean isValid() {
        return StringUtils.isNotEmpty((CharSequence)this.projectId) && StringUtils.isNotEmpty((CharSequence)this.userIdentifier) && StringUtils.isNotEmpty((CharSequence)this.tokenSecret);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public SmartlingCloudConfig getForLocale(String locale) {
        if (StringUtils.isBlank((CharSequence)locale)) {
            return this;
        }
        SmartlingCredentials credentials = this.smartlingCredentials.get(locale);
        if (credentials == null) {
            return this;
        }
        return new JcrSmartlingCloudConfigWrapper(this, credentials);
    }

    @Override
    public SmartlingCloudConfig getForProject(String projectUid) {
        Optional<SmartlingCredentials> credentials = this.smartlingCredentials.values().stream().filter(creds -> StringUtils.equalsIgnoreCase((CharSequence)creds.getProjectId(), (CharSequence)projectUid)).findFirst();
        if (!credentials.isPresent()) {
            return this;
        }
        return new JcrSmartlingCloudConfigWrapper(this, credentials.get());
    }

    @Override
    public List<SmartlingProjectLocaleCredentials> getLocaleProjectConfigs() {
        return this.smartlingCredentials.keySet().stream().map(k -> {
            SmartlingCredentials credentials = this.smartlingCredentials.get(k);
            return new JcrSmartlingProjectLocaleCredentialsWrapper(this.cryptoSupport, credentials, (String)k);
        }).collect(Collectors.toList());
    }

    private void initSmartlingCredentials(String smartlingCredentialStr) {
        try {
            if (StringUtils.isNotBlank((CharSequence)smartlingCredentialStr)) {
                Type listType = new TypeToken<ArrayList<SmartlingProjectCredentials>>(){}.getType();
                List smartlingCredentialList = (List)this.GSON.fromJson(smartlingCredentialStr, listType);
                smartlingCredentialList.forEach(smartlingCredential -> this.smartlingCredentials.put(smartlingCredential.getLocale(), (SmartlingCredentials)smartlingCredential));
            }
        }
        catch (Exception ex) {
            LOGGER.error("Couldn't initialize list of Smartling credentials", (Throwable)ex);
        }
    }

    public String toString() {
        return "JcrSmartlingCloudConfig {path=\"" + this.path + "\", projectId=\"" + this.projectId + "\", languageMapping=\"" + this.languageMapping + "\"}";
    }

    static class JcrSmartlingProjectLocaleCredentialsWrapper
    implements SmartlingProjectLocaleCredentials {
        private final CryptoSupport cryptoSupport;
        private final SmartlingCredentials credentials;
        private final String locale;

        public JcrSmartlingProjectLocaleCredentialsWrapper(CryptoSupport cryptoSupport, SmartlingCredentials credentials, String locale) {
            this.cryptoSupport = cryptoSupport;
            this.credentials = credentials;
            this.locale = locale;
        }

        @Override
        public String getLocale() {
            return this.locale;
        }

        @Override
        public boolean isValid() {
            return StringUtils.isNotEmpty((CharSequence)this.locale) && StringUtils.isNotEmpty((CharSequence)this.credentials.getProjectId()) && StringUtils.isNotEmpty((CharSequence)this.credentials.getUserIdentifier()) && StringUtils.isNotEmpty((CharSequence)this.credentials.getTokenSecret());
        }

        @Override
        public String getProjectId() {
            return this.credentials.getProjectId();
        }

        @Override
        public String getUserIdentifier() {
            return this.credentials.getUserIdentifier();
        }

        @Override
        public String getTokenSecret() {
            try {
                return this.cryptoSupport.unprotect(this.credentials.getTokenSecret());
            }
            catch (CryptoException e) {
                throw new IllegalStateException("Failed to decrypt a token secret", e);
            }
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    static class JcrSmartlingCloudConfigWrapper
    implements SmartlingCloudConfig {
        private final JcrSmartlingCloudConfig config;
        private final SmartlingCredentials credentials;

        public JcrSmartlingCloudConfigWrapper(JcrSmartlingCloudConfig config, SmartlingCredentials credentials) {
            this.config = config;
            this.credentials = credentials;
        }

        @Override
        public String getPath() {
            return this.config.getPath();
        }

        @Override
        public Map<String, String> getLanguageMapping() {
            return this.config.getLanguageMapping();
        }

        @Override
        public boolean isValid() {
            return StringUtils.isNotEmpty((CharSequence)this.credentials.getProjectId()) && StringUtils.isNotEmpty((CharSequence)this.credentials.getUserIdentifier()) && StringUtils.isNotEmpty((CharSequence)this.credentials.getTokenSecret());
        }

        @Override
        public boolean isDirectionSupported(String sourceLanguage, String targetLanguage) throws SmartlingException {
            return this.config.isDirectionSupported(this, sourceLanguage, targetLanguage);
        }

        @Override
        public SmartlingCloudConfig getForLocale(String locale) {
            return this;
        }

        @Override
        public SmartlingCloudConfig getForProject(String projectUid) {
            return this;
        }

        @Override
        public List<SmartlingProjectLocaleCredentials> getLocaleProjectConfigs() {
            return this.config.getLocaleProjectConfigs();
        }

        @Override
        public Set<String> mapSmartlingCodeToLocale(String smartlingLocaleCode) {
            return this.config.mapSmartlingCodeToLocale(smartlingLocaleCode);
        }

        @Override
        public String getProjectId() {
            return this.credentials.getProjectId();
        }

        @Override
        public String getUserIdentifier() {
            return this.credentials.getUserIdentifier();
        }

        @Override
        public String getTokenSecret() {
            try {
                return this.config.cryptoSupport.unprotect(this.credentials.getTokenSecret());
            }
            catch (CryptoException e) {
                throw new IllegalStateException("Failed to decrypt a token secret", e);
            }
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    static class AEMLocaleComparator
    implements Comparator<String> {
        AEMLocaleComparator() {
        }

        @Override
        public int compare(String locale1, String locale2) {
            if (locale1 == null || locale2 == null) {
                return String.CASE_INSENSITIVE_ORDER.compare(locale1, locale2);
            }
            String lang1WithHyphen = locale1.replace("_", "-");
            String lang2WithHyphen = locale2.replace("_", "-");
            return String.CASE_INSENSITIVE_ORDER.compare(lang1WithHyphen, lang2WithHyphen);
        }
    }
}

