/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={TranslatableContentConfigurationsService.class})
@Designate(ocd=Config.class)
public class TranslatableContentConfigurationsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslatableContentConfigurationsService.class);
    public static final String CUSTOM_PLACEHOLDER_FORMAT_DEFAULT = "\\{\\d(,(number|date|time)(,[^,\\{\\}]+?)?)?}";
    private String customPlaceholderFormatValue;
    private Map<String, String> customDirectives;

    @Activate
    public void activate(Config config) {
        this.customPlaceholderFormatValue = config.custom_placeholder_format();
        String[] customDirectivesArray = config.custom_directives_list();
        this.parseCustomDirectives(customDirectivesArray);
    }

    public String getCustomPlaceholderFormatValue() {
        return this.customPlaceholderFormatValue;
    }

    public Map<String, String> getCustomDirectives() {
        return this.customDirectives;
    }

    private void parseCustomDirectives(String[] directivesArray) {
        this.customDirectives = new HashMap<String, String>();
        for (String directive : directivesArray) {
            String[] keyValuePair = StringUtils.split((String)directive, (String)"=");
            if (keyValuePair.length != 2) {
                LOGGER.warn("Invalid directive \"{}\" was skipped from upload.", (Object)directive);
                continue;
            }
            String key = StringUtils.trim((String)keyValuePair[0]);
            String value = StringUtils.trim((String)keyValuePair[1]);
            if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) {
                LOGGER.warn("Invalid directive \"{}\" was skipped from upload.", (Object)directive);
                continue;
            }
            this.customDirectives.put(key, value);
        }
    }

    @ObjectClassDefinition(name="Smartling - Translatable Content Configuration (Touch)", description="ATTENTION! This configuration should be set during initial setup as changing it may result in new content for translation or loss of existing translations on a page.")
    public static @interface Config {
        @AttributeDefinition(name="Custom Placeholder", description="Valid regular expression (https://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html) which will be used by File API for masking content")
        public String custom_placeholder_format() default "\\{\\d(,(number|date|time)(,[^,\\{\\}]+?)?)?}";

        @AttributeDefinition(name="Custom Directives list", description="List of custom directives that will be sent within a file. An example \"smartling.include_translatable_attributes = title\".")
        public String[] custom_directives_list() default {};
    }
}

