/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.instant;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationDetailsManager;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationJobDetails;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationObjectDetails;
import com.smartling.aem.connector.core.FileUriResolver;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingCredentials;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.BaseSmartlingFacade;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.aem.connector.core.impl.integration.TranslationCancelRequest;
import com.smartling.aem.connector.core.impl.integration.TranslationDownloadRequest;
import com.smartling.aem.connector.core.impl.integration.TranslationStatusRequest;
import com.smartling.aem.connector.core.impl.integration.TranslationUploadRequest;
import com.smartling.aem.connector.core.impl.integration.TranslationUploadResult;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClientFactory;
import com.smartling.aem.connector.core.impl.integration.platform.instant.InstantSmartlingPlatformClient;
import com.smartling.aem.connector.core.impl.integration.platform.instant.InstantSmartlingPlatformClientFactory;
import com.smartling.api.projects.v2.pto.ProjectDetailsPTO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={InstantSmartlingFacade.class})
@Designate(ocd=Config.class)
public class InstantSmartlingFacade
extends BaseSmartlingFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstantSmartlingFacade.class);
    private static final Gson GSON = new GsonBuilder().create();
    private static final int POLLING_INTERVAL_MS = 200;
    private static final int POLLING_INTERVAL_TOTAL_MS = 5000;
    private static final int DEFAULT_POOL_SIZE = 4;
    private static final int MIN_POOL_SIZE = 2;
    private static final int MAX_POOL_SIZE = 4;
    private static final int THREAD_KEEP_ALIVE_SECONDS = 10;
    @Reference
    private InstantSmartlingPlatformClientFactory instantSmartlingPlatformClientFactory;
    @Reference
    private TranslationDetailsManager translationDetailsManager;
    @Reference
    private FileUriResolver fileUriResolver;
    @Reference
    private ProjectApiClientFactory projectApiClientFactory;
    private Executor executor;

    @Activate
    protected void activate(Config config) {
        int poolSize = 4;
        try {
            poolSize = config.pool_size();
            if (poolSize < 2 || poolSize > 4) {
                LOGGER.warn("Pool size {} is out of valid range [{}, {}]. Using default value '{}'", new Object[]{poolSize, 2, 4, 4});
                poolSize = 4;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while setting pool size. Default value '{}' was applied", (Object)4, (Object)e);
        }
        this.executor = InstantSmartlingFacade.createThreadPool(poolSize);
    }

    @Deactivate
    protected void deactivate() {
        if (this.executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executor;
            threadPoolExecutor.shutdown();
            try {
                if (!threadPoolExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOGGER.warn("Thread pool did not terminate within 5 seconds, forcing shutdown");
                    threadPoolExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Thread pool shutdown interrupted", (Throwable)e);
                threadPoolExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private static Executor createThreadPool(int maximumPoolSize) {
        ThreadFactory threadFactory = InstantSmartlingFacade.namedThreadFactory();
        return new ThreadPoolExecutor(0, maximumPoolSize, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String uploadFile(SmartlingCloudConfig config, String jobId, SmartlingFacade.Resource resource) throws SmartlingException {
        Optional<String> resourcePath = resource.getPath();
        String resourceId = resourcePath.orElse(resource.getTitle());
        TranslationObjectDetails translationObjectDetails = this.translationDetailsManager.getTranslationObjectDetails(jobId, resource.getPath().orElse(null));
        if (translationObjectDetails == null) {
            throw new SmartlingException("Translation object details not found for jobId=\"" + jobId + "\", resourcePath=\"" + (String)resource.getPath().orElse(null) + "\"");
        }
        SmartlingCloudConfig sourceCloudConfig = StringUtils.isNotBlank((CharSequence)translationObjectDetails.getProjectUid()) ? config.getForProject(translationObjectDetails.getProjectUid()) : config.getForLocale(translationObjectDetails.getConfigSourceLocaleCode());
        String aemSourceLocaleCode = translationObjectDetails.getSourceLanguage();
        String sourceLanguage = this.mapToSmartlingLocaleCode(aemSourceLocaleCode, sourceCloudConfig.getLanguageMapping());
        this.updateSmartlingInfo(sourceCloudConfig, translationObjectDetails, jobId, resourceId);
        try (InstantSmartlingPlatformClient client = this.instantSmartlingPlatformClientFactory.createClient(sourceCloudConfig);){
            TranslationUploadRequest uploadRequest = TranslationUploadRequest.builder().resource(resource).smartlingSourceLocaleCode(sourceLanguage).accountUid(translationObjectDetails.getAccountUid()).build();
            TranslationUploadResult uploadResult = client.sendForTranslation(uploadRequest);
            String string = this.fileUriResolver.createFileUri(resourceId, uploadResult.getFileUid(), uploadResult.getMtUid());
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't upload file=\"{}\"", (Object)resourceId, (Object)e);
            throw new SmartlingException("Couldn't upload file=\"" + resourceId + "\"", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SmartlingFacade.Status getObjectStatus(SmartlingCloudConfig config, String jobId, String translationObjectId) throws SmartlingException {
        try (InstantSmartlingPlatformClient client = this.instantSmartlingPlatformClientFactory.createClient(config);){
            FileUriResolver.MtFileInfo fileInfo = this.fileUriResolver.resolveFileInfo(translationObjectId);
            if (fileInfo == null) {
                throw new SmartlingException("Couldn't resolve fileUri=\"" + translationObjectId + "\"");
            }
            TranslationJobDetails translationJobDetails = this.translationDetailsManager.getTranslationJobDetails(jobId);
            if (translationJobDetails == null) {
                throw new SmartlingException("Translation job details not found for jobId=\"" + jobId + "\"");
            }
            TranslationStatusRequest statusRequest = TranslationStatusRequest.builder().fileUid(fileInfo.getFileUid()).mtUid(fileInfo.getMtUid()).accountUid(translationJobDetails.getAccountUid()).build();
            SmartlingFacade.Status status = client.getStatus(statusRequest);
            return status;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't get status for file=\"{}\"", (Object)translationObjectId, (Object)e);
            throw new SmartlingException("Couldn't get status for file=\"" + translationObjectId + "\"", e);
        }
    }

    @Override
    public SmartlingFacade.Status getJobStatus(SmartlingCloudConfig config, String jobId) throws SmartlingException {
        return SmartlingFacade.Status.COMPLETED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getTranslatedFile(SmartlingCloudConfig config, String jobId, String fileUri) throws SmartlingException {
        try (InstantSmartlingPlatformClient client = this.instantSmartlingPlatformClientFactory.createClient(config);){
            FileUriResolver.MtFileInfo fileInfo = this.fileUriResolver.resolveFileInfo(fileUri);
            if (fileInfo == null) {
                throw new SmartlingException("Couldn't resolve fileUri=\"" + fileUri + "\"");
            }
            TranslationJobDetails translationJobDetails = this.translationDetailsManager.getTranslationJobDetails(jobId);
            if (translationJobDetails == null) {
                throw new SmartlingException("Translation job details not found for jobId=\"" + jobId + "\"");
            }
            SmartlingCloudConfig sourceCloudConfig = StringUtils.isNotBlank((CharSequence)translationJobDetails.getProjectUid()) ? config.getForProject(translationJobDetails.getProjectUid()) : config.getForLocale(translationJobDetails.getConfigSourceLocaleCode());
            String aemTargetLocaleCode = translationJobDetails.getTargetLanguage();
            String smartlingTargetLanguage = this.mapToSmartlingLocaleCode(aemTargetLocaleCode, sourceCloudConfig.getLanguageMapping());
            TranslationDownloadRequest downloadRequest = TranslationDownloadRequest.builder().fileUid(fileInfo.getFileUid()).mtUid(fileInfo.getMtUid()).accountUid(translationJobDetails.getAccountUid()).smartlingTargetLocale(smartlingTargetLanguage).build();
            InputStream inputStream = client.getTranslated(downloadRequest);
            return inputStream;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't download file=\"{}\"", (Object)fileUri, (Object)e);
            throw new SmartlingException("Couldn't download file=\"" + fileUri + "\"", e);
        }
    }

    @Override
    public void deleteFile(SmartlingCloudConfig config, String jobId, String fileUri) throws SmartlingException {
        try (InstantSmartlingPlatformClient client = this.instantSmartlingPlatformClientFactory.createClient(config);){
            FileUriResolver.MtFileInfo fileInfo = this.fileUriResolver.resolveFileInfo(fileUri);
            if (fileInfo == null) {
                throw new SmartlingException("Couldn't resolve fileUri=\"" + fileUri + "\"");
            }
            TranslationJobDetails translationJobDetails = this.translationDetailsManager.getTranslationJobDetails(jobId);
            if (translationJobDetails == null) {
                throw new SmartlingException("Translation job details not found for jobId=\"" + jobId + "\"");
            }
            TranslationCancelRequest cancelRequest = TranslationCancelRequest.builder().fileUid(fileInfo.getFileUid()).mtUid(fileInfo.getMtUid()).accountUid(translationJobDetails.getAccountUid()).build();
            client.delete(cancelRequest);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't cancel translation request for file=\"{}\"", (Object)fileUri, (Object)e);
            throw new SmartlingException("Couldn't cancel translation request for file=\"" + fileUri + "\"", e);
        }
    }

    @Override
    public void deleteTranslationJob(SmartlingCloudConfig config, String jobId) throws SmartlingException {
    }

    @Override
    public boolean autoAuthorize() {
        return false;
    }

    /*
     * Exception decompiling
     */
    public String[] translateArray(SmartlingCloudConfig config, String[] strings, String aemSourceLanguage, String aemTargetLanguage) throws SmartlingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SmartlingFacade.Status pollStatus(InstantSmartlingPlatformClient client, TranslationStatusRequest statusRequest) {
        try {
            SmartlingFacade.Status status;
            int restInterval = 5000;
            do {
                Thread.sleep(200L);
                status = client.getStatus(statusRequest);
            } while ((restInterval -= 200) > 0 && status != SmartlingFacade.Status.COMPLETED && status != SmartlingFacade.Status.FAILED);
            return status;
        }
        catch (InterruptedException e) {
            LOGGER.error("Couldn't check status for fileUid=\"{}\", mtUid=\"{}\"", new Object[]{statusRequest.getFileUid(), statusRequest.getMtUid(), e});
            Thread.currentThread().interrupt();
        }
        catch (SmartlingException e) {
            LOGGER.error("Couldn't check status for fileUid=\"{}\", mtUid=\"{}\"", new Object[]{statusRequest.getFileUid(), statusRequest.getMtUid(), e});
        }
        return SmartlingFacade.Status.FAILED;
    }

    private void updateSmartlingInfo(SmartlingCredentials credentials, TranslationObjectDetails translationObjectDetails, String aemTranslationJob, String resourceId) throws SmartlingException {
        if (StringUtils.isNotBlank((CharSequence)translationObjectDetails.getProjectUid()) && StringUtils.isNotBlank((CharSequence)translationObjectDetails.getAccountUid())) {
            return;
        }
        try (ProjectApiClient projectApiClient = this.projectApiClientFactory.createClient(credentials);){
            ProjectDetailsPTO details = projectApiClient.getProjectDetails();
            this.translationDetailsManager.setTranslationProjectUid(aemTranslationJob, details.getProjectId());
            this.translationDetailsManager.setTranslationProjectAccountUid(aemTranslationJob, details.getAccountUid());
            translationObjectDetails.setProjectUid(details.getProjectId());
            translationObjectDetails.setAccountUid(details.getAccountUid());
        }
        catch (Exception e) {
            LOGGER.error("Couldn't update smartling platform credentials for object=\"{}\"", (Object)resourceId, (Object)e);
            throw new SmartlingException("Couldn't update smartling platform credentials for object=\"" + resourceId + "\"", e);
        }
    }

    private InputStream createJSONContentStream(String[] strings) throws SmartlingException {
        TranslationContent content = new TranslationContent(strings);
        String json = GSON.toJson((Object)content);
        return IOUtils.toInputStream((String)json, (Charset)StandardCharsets.UTF_8);
    }

    private String[] parseJSONTranslation(InputStream content) throws SmartlingException {
        try {
            String jsonStr = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
            TranslationContent translationContent = (TranslationContent)GSON.fromJson(jsonStr, TranslationContent.class);
            return translationContent.getStrings();
        }
        catch (IOException e) {
            throw new SmartlingException("Couldn't parse content stream for strings", e);
        }
    }

    private static ThreadFactory namedThreadFactory() {
        final ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
        final AtomicLong count = new AtomicLong(0L);
        return new ThreadFactory(){

            @Override
            public Thread newThread(@NotNull Runnable runnable) {
                Thread thread = backingThreadFactory.newThread(runnable);
                thread.setName(String.format("instant-translation-polling-%d", count.getAndIncrement()));
                return thread;
            }
        };
    }

    private static /* synthetic */ SmartlingFacade.Status lambda$translateArray$0(InstantSmartlingPlatformClient client, TranslationStatusRequest statusRequest) {
        return InstantSmartlingFacade.pollStatus(client, statusRequest);
    }

    static class TranslationContent {
        String[] strings;

        public static TranslationContentBuilder builder() {
            return new TranslationContentBuilder();
        }

        public String[] getStrings() {
            return this.strings;
        }

        public void setStrings(String[] strings) {
            this.strings = strings;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TranslationContent)) {
                return false;
            }
            TranslationContent other = (TranslationContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.deepEquals(this.getStrings(), other.getStrings());
        }

        protected boolean canEqual(Object other) {
            return other instanceof TranslationContent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getStrings());
            return result;
        }

        public String toString() {
            return "InstantSmartlingFacade.TranslationContent(strings=" + Arrays.deepToString(this.getStrings()) + ")";
        }

        public TranslationContent(String[] strings) {
            this.strings = strings;
        }

        public TranslationContent() {
        }

        public static class TranslationContentBuilder {
            private String[] strings;

            TranslationContentBuilder() {
            }

            public TranslationContentBuilder strings(String[] strings) {
                this.strings = strings;
                return this;
            }

            public TranslationContent build() {
                return new TranslationContent(this.strings);
            }

            public String toString() {
                return "InstantSmartlingFacade.TranslationContent.TranslationContentBuilder(strings=" + Arrays.deepToString(this.strings) + ")";
            }
        }
    }

    @ObjectClassDefinition(name="Smartling - Instant Translation Facade (Touch)", description="Controls the last step of the \"request translation\" flow on the AEM side")
    public static @interface Config {
        @AttributeDefinition(name="Pool Size", description="Number of parallel threads used to poll translation status (max 4, min 2)")
        public int pool_size() default 4;
    }
}

