/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration;

import com.smartling.aem.connector.automation.impl.wcm.project.TranslationDetailsManager;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationJobDetails;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationObjectDetails;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.BaseSmartlingFacade;
import com.smartling.aem.connector.core.impl.PseudoContentDownloadManager;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.aem.connector.core.impl.integration.BatchIsNotSuitableException;
import com.smartling.aem.connector.core.impl.integration.NoTranslatableContentException;
import com.smartling.aem.connector.core.impl.integration.SmartlingPlatformClient;
import com.smartling.aem.connector.core.impl.integration.SmartlingPlatformClientFactory;
import com.smartling.aem.connector.core.impl.integration.TranslationCancelRequest;
import com.smartling.aem.connector.core.impl.integration.TranslationDownloadRequest;
import com.smartling.aem.connector.core.impl.integration.TranslationStatusRequest;
import com.smartling.aem.connector.core.impl.integration.TranslationUploadRequest;
import com.smartling.aem.connector.core.impl.integration.platform.Job;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClientFactory;
import com.smartling.aem.connector.core.impl.integration.platform.jobs.JobUtil;
import com.smartling.api.files.v2.pto.RetrievalType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SynchronousSmartlingFacade.class}, immediate=true)
@Designate(ocd=Config.class)
public class SynchronousSmartlingFacade
extends BaseSmartlingFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronousSmartlingFacade.class);
    @Reference
    private SmartlingPlatformClientFactory smartlingPlatformClientFactory;
    @Reference
    private JobApiClientFactory jobApiClientFactory;
    @Reference
    private TranslationDetailsManager translationDetailsManager;
    @Reference
    private PseudoContentDownloadManager pseudoContentDownloadManager;
    private boolean autoAuthorize;
    private boolean moveStrings;

    @Activate
    protected void activate(Config config) {
        this.autoAuthorize = config.auto_authorize();
        this.moveStrings = config.move_strings();
    }

    @Override
    public String uploadFile(SmartlingCloudConfig config, String jobId, SmartlingFacade.Resource resource) throws SmartlingException {
        Optional<String> resourcePath = resource.getPath();
        String resourceId = resourcePath.orElse(resource.getTitle());
        String fileUri = jobId + ":" + resourceId;
        TranslationObjectDetails translationObjectDetails = this.translationDetailsManager.getTranslationObjectDetails(jobId, resourcePath.orElse(null));
        String aemSourceLocaleCode = translationObjectDetails.getSourceLanguage();
        String sourceLanguage = this.mapToSmartlingLocaleCode(aemSourceLocaleCode, config.getLanguageMapping());
        String targetLanguage = this.mapToSmartlingLocaleCode(translationObjectDetails.getTargetLanguage(), config.getLanguageMapping());
        SmartlingCloudConfig sourceCloudConfig = StringUtils.isNotBlank((CharSequence)translationObjectDetails.getProjectUid()) ? config.getForProject(translationObjectDetails.getProjectUid()) : config.getForLocale(translationObjectDetails.getConfigSourceLocaleCode());
        String jobUid = translationObjectDetails.getJobUid();
        boolean authorize = this.autoAuthorize() || translationObjectDetails.isAutoAuthorize();
        Job job = this.getSmartlingJob(jobUid, sourceCloudConfig, fileUri);
        String jobName = job == null ? null : job.getName();
        String batchUid = null;
        if (job != null && Job.State.CANCELLED != job.getState() && Job.State.CLOSED != job.getState() && Job.State.DELETED != job.getState() && Job.State.UNKNOWN != job.getState()) {
            batchUid = translationObjectDetails.getBatchUid();
        } else {
            if (job != null) {
                LOGGER.info("Currently specified job jobUid=\"{}\" has status=\"{}\" so new Smartling job should be used", (Object)job.getUid(), (Object)job.getState().name());
            }
            jobUid = null;
        }
        TranslationUploadRequest request = TranslationUploadRequest.builder().jobId(jobId).aemSourceLocaleCode(aemSourceLocaleCode).aemTargetLocaleCode(translationObjectDetails.getTargetLanguage()).resource(resource).fileUri(fileUri).jobUid(jobUid).batchUid(batchUid).jobName(jobName).projectUid(sourceCloudConfig.getProjectId()).smartlingSourceLocaleCode(sourceLanguage).smartlingTargetLocaleCode(targetLanguage).authorize(authorize).moveStrings(this.moveStrings).localeWorkflows(translationObjectDetails.getLocaleWorkflows()).build();
        try {
            if (StringUtils.isNotEmpty((CharSequence)batchUid)) {
                this.uploadWithinBatch(request, sourceCloudConfig);
            } else {
                this.uploadNativeAEMTranslation(request, sourceCloudConfig);
            }
        }
        catch (Exception e) {
            LOGGER.error("General error on upload file request for jobUid=\"{}\".", (Object)jobId, (Object)e);
            throw new SmartlingException("General error on upload file request for jobUid=\"" + jobId + "\".", e);
        }
        return fileUri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Job getSmartlingJob(String jobUid, SmartlingCloudConfig sourceCloudConfig, String fileUri) {
        if (!StringUtils.isNotBlank((CharSequence)jobUid)) return null;
        try (JobApiClient jobApiClient = this.jobApiClientFactory.createClient(sourceCloudConfig);){
            Job job = jobApiClient.loadJob(jobUid);
            return job;
        }
        catch (Exception e) {
            LOGGER.error("General error on checking a jobUid=\"{}\" for fileUri=\"{}\".", new Object[]{jobUid, fileUri, e});
            return null;
        }
    }

    private void uploadWithinBatch(TranslationUploadRequest request, SmartlingCloudConfig sourceCloudConfig) throws SmartlingException {
        try (SmartlingPlatformClient platformClient = this.smartlingPlatformClientFactory.createClient(sourceCloudConfig);){
            platformClient.sendForTranslation(request);
        }
        catch (BatchIsNotSuitableException e) {
            LOGGER.info("Batch batchUid=\"{}\" for jobUid=\"{}\" is not suitable anymore. Trying to upload within new batch.", (Object)request.getBatchUid(), (Object)request.getJobUid());
            try {
                request.getResource().getContentStream().reset();
            }
            catch (IOException ex) {
                throw new SmartlingException("Couldn't reset stream for file fileUri=\"" + request.getFileUri() + "\" batch batchUID=\"" + request.getBatchUid() + "\".", ex);
            }
            this.uploadWithinNewBatch(request, sourceCloudConfig);
            LOGGER.info("New batch batchUid=\"{}\" is used for uploading fileUri=\"{}\"", (Object)request.getBatchUid(), (Object)request.getFileUri());
            this.translationDetailsManager.setTranslationProjectBatchUid(request.getJobId(), null);
        }
        catch (NoTranslatableContentException e) {
            LOGGER.error("No translatable content for file fileUri=\"{}\" to batch batchUID=\"{}\".", new Object[]{request.getFileUri(), request.getBatchUid(), e});
            throw e;
        }
        catch (Exception e) {
            throw new SmartlingException("Couldn't upload file fileUri=\"" + request.getFileUri() + "\" to batch batchUID=\"" + request.getBatchUid() + "\".", e);
        }
    }

    private void uploadNativeAEMTranslation(TranslationUploadRequest request, SmartlingConfig config) throws SmartlingException {
        String resourceId = request.getResource().getPath().orElse(request.getResource().getTitle());
        if (StringUtils.isEmpty((CharSequence)request.getJobUid())) {
            try (JobApiClient jobApiClient = this.jobApiClientFactory.createClient(config);){
                String jobName = StringUtils.isBlank((CharSequence)request.getJobName()) ? JobUtil.generateJobName(resourceId) : JobUtil.enrichJobNameWithSuffix(request.getJobName());
                request.setJobName(jobName);
                String jobUid = jobApiClient.createJob(request.getJobName(), Collections.singletonList(request.getSmartlingTargetLocaleCode()), null);
                request.setJobUid(jobUid);
                this.translationDetailsManager.setTranslationProjectJobUid(request.getJobId(), request.getJobUid());
            }
            catch (Exception e) {
                throw new SmartlingException("General error on creating a job for fileUri=\"" + request.getFileUri() + "\".", e);
            }
        }
        this.uploadWithinNewBatch(request, config);
    }

    private void uploadWithinNewBatch(TranslationUploadRequest request, SmartlingConfig config) throws SmartlingException {
        String batchUid = null;
        try (SmartlingPlatformClient platformClient = this.smartlingPlatformClientFactory.createClient(config);){
            batchUid = platformClient.createBatch(request.getProjectUid(), request.getJobUid(), request.isAuthorize());
            request.setBatchUid(batchUid);
            platformClient.sendForTranslation(request);
            platformClient.executeBatch(request.getProjectUid(), request.getBatchUid(), request.getLocaleWorkflows());
        }
        catch (NoTranslatableContentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SmartlingException("Couldn't upload file fileUri=\"" + request.getFileUri() + "\" to job jobUID=\"" + request.getJobUid() + "\".", e);
        }
        request.setBatchUid(batchUid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SmartlingFacade.Status getObjectStatus(SmartlingCloudConfig config, String jobId, String translationObjectId) throws SmartlingException {
        TranslationJobDetails translationJobDetails = this.translationDetailsManager.getTranslationJobDetails(jobId);
        String targetAEMLanguage = translationJobDetails.getTargetLanguage();
        String targetLanguage = this.mapToSmartlingLocaleCode(targetAEMLanguage, config.getLanguageMapping());
        if (translationJobDetails.isPseudo()) {
            return SmartlingFacade.Status.COMPLETED;
        }
        SmartlingCloudConfig sourceCloudConfig = this.getSourceCloudConfig(config, translationJobDetails);
        try (SmartlingPlatformClient platformClient = this.smartlingPlatformClientFactory.createClient(sourceCloudConfig);){
            TranslationStatusRequest statusRequest = TranslationStatusRequest.builder().projectUid(sourceCloudConfig.getProjectId()).fileUri(translationObjectId).languageCode(targetLanguage).build();
            SmartlingFacade.Status status = platformClient.getStatus(statusRequest);
            return status;
        }
        catch (Exception e) {
            LOGGER.error("General error on checking status for fileUri=\"{}\".", (Object)translationObjectId, (Object)e);
            throw new SmartlingException("General error on checking status for fileUri=\"" + translationObjectId + "\".", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SmartlingFacade.Status getJobStatus(SmartlingCloudConfig config, String jobId) throws SmartlingException {
        TranslationJobDetails translationJobDetails = this.translationDetailsManager.getTranslationJobDetails(jobId);
        String targetAEMLanguage = translationJobDetails.getTargetLanguage();
        SmartlingCloudConfig sourceCloudConfig = this.getSourceCloudConfig(config, translationJobDetails);
        String targetLanguage = this.mapToSmartlingLocaleCode(targetAEMLanguage, config.getLanguageMapping());
        try (SmartlingPlatformClient platformClient = this.smartlingPlatformClientFactory.createClient(sourceCloudConfig);){
            SmartlingFacade.Status status = platformClient.getJobStatus(jobId, targetLanguage);
            return status;
        }
        catch (Exception e) {
            LOGGER.error("General error on checking job status for jobUid=\"{}\".", (Object)jobId, (Object)e);
            throw new SmartlingException("General error on checking job status for jobUid=\"" + jobId + "\".", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getTranslatedFile(SmartlingCloudConfig config, String jobId, String fileUri) throws SmartlingException {
        TranslationJobDetails translationJobDetails = this.translationDetailsManager.getTranslationJobDetails(jobId);
        String targetAEMLanguage = translationJobDetails.getTargetLanguage();
        SmartlingCloudConfig sourceCloudConfig = this.getSourceCloudConfig(config, translationJobDetails);
        String targetLanguage = this.mapToSmartlingLocaleCode(targetAEMLanguage, sourceCloudConfig.getLanguageMapping());
        RetrievalType retrievalType = translationJobDetails.isPseudo() ? RetrievalType.PSEUDO : RetrievalType.PUBLISHED;
        try (SmartlingPlatformClient platformClient = this.smartlingPlatformClientFactory.createClient(sourceCloudConfig);){
            TranslationDownloadRequest downloadRequest = TranslationDownloadRequest.builder().projectUid(sourceCloudConfig.getProjectId()).fileUri(fileUri).smartlingTargetLocale(targetLanguage).retrievalType(retrievalType).build();
            InputStream contentStream = platformClient.getTranslated(downloadRequest);
            if (retrievalType == RetrievalType.PSEUDO && this.pseudoContentDownloadManager.shouldRemoveFileAfterDownload()) {
                this.deleteFile(sourceCloudConfig, fileUri);
            }
            InputStream inputStream = contentStream;
            return inputStream;
        }
        catch (Exception e) {
            LOGGER.error("General error on downloading translation for fileUri=\"{}\".", (Object)fileUri, (Object)e);
            throw new SmartlingException("General error on downloading translation for fileUri=\"" + fileUri + "\".", e);
        }
    }

    @Override
    public void deleteFile(SmartlingCloudConfig config, String jobId, String fileUri) throws SmartlingException {
        TranslationJobDetails translationJobDetails = this.translationDetailsManager.getTranslationJobDetails(jobId);
        SmartlingCloudConfig sourceCloudConfig = this.getSourceCloudConfig(config, translationJobDetails);
        this.deleteFile(sourceCloudConfig, fileUri);
    }

    @Override
    public void deleteTranslationJob(SmartlingCloudConfig config, String jobId) throws SmartlingException {
        TranslationJobDetails translationJobDetails = this.translationDetailsManager.getTranslationJobDetails(jobId);
        SmartlingCloudConfig sourceCloudConfig = this.getSourceCloudConfig(config, translationJobDetails);
        List<String> fileUris = translationJobDetails.getTranslationObjectIds();
        try (SmartlingPlatformClient platformClient = this.smartlingPlatformClientFactory.createClient(sourceCloudConfig);){
            for (String fileUri : fileUris) {
                TranslationCancelRequest cancelRequest = TranslationCancelRequest.builder().projectUid(sourceCloudConfig.getProjectId()).fileUri(fileUri).build();
                platformClient.delete(cancelRequest);
            }
        }
        catch (Exception e) {
            LOGGER.error("General error on deleting a file for AEM job by jobId=\"{}\".", (Object)jobId, (Object)e);
            throw new SmartlingException("General error on deleting a file for AEM job by jobId=\"" + jobId + "\".", e);
        }
    }

    @Override
    public boolean autoAuthorize() {
        return this.autoAuthorize;
    }

    private SmartlingCloudConfig getSourceCloudConfig(SmartlingCloudConfig config, TranslationJobDetails translationJobDetails) {
        return StringUtils.isNotBlank((CharSequence)translationJobDetails.getProjectUid()) ? config.getForProject(translationJobDetails.getProjectUid()) : config.getForLocale(translationJobDetails.getConfigSourceLocaleCode());
    }

    public void deleteFile(SmartlingCloudConfig config, String fileUri) throws SmartlingException {
        try (SmartlingPlatformClient platformClient = this.smartlingPlatformClientFactory.createClient(config);){
            TranslationCancelRequest cancelRequest = TranslationCancelRequest.builder().projectUid(config.getProjectId()).fileUri(fileUri).build();
            platformClient.delete(cancelRequest);
        }
        catch (Exception e) {
            LOGGER.error("General error on deleting file by fileUri=\"{}\".", (Object)fileUri, (Object)e);
            throw new SmartlingException("General error on deleting file by fileUri=\"" + fileUri + "\".", e);
        }
    }

    @ObjectClassDefinition(name="Smartling - Smartling Facade (Touch)", description="Controls the last step of the \"request translation\" flow on the AEM side")
    public static @interface Config {
        @AttributeDefinition(name="Auto authorize", description="This option presets the \"Auto authorize\" checkbox in the \"Smartling - Translate\" dialog. It also manages content authorization for requests from the AEM \"References Panel\"")
        public boolean auto_authorize() default false;

        @AttributeDefinition(name="Move strings", description="AEM creates a new file version on each upload, but the strings are shared across file versions. By default, only new strings are attached to the requested job. If checked, existing untranslated strings will be moved from other jobs to the requested job.")
        public boolean move_strings() default false;
    }
}

