/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform.auditlog;

import com.smartling.aem.connector.automation.impl.TranslationRequest;
import com.smartling.aem.connector.core.impl.integration.platform.AuditLogClient;
import com.smartling.aem.connector.core.impl.integration.platform.auditlog.ActionTypes;
import com.smartling.auditlog.sdk.AuditLogApi;
import com.smartling.auditlog.sdk.pto.CreateLogRecordCommandPTO;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogClientImpl
implements AuditLogClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogClientImpl.class);
    private final AuditLogApi auditLogApi;
    private final String projectUid;

    AuditLogClientImpl(AuditLogApi auditLogApi, String projectUid) {
        this.auditLogApi = auditLogApi;
        this.projectUid = projectUid;
    }

    @Override
    public void logStartSmartlingWorkflow(TranslationRequest translationRequest) {
        TreeMap<String, Comparable<Boolean>> customData = new TreeMap<String, Comparable<Boolean>>();
        customData.put("isDeep", Boolean.valueOf(translationRequest.isDeep()));
        customData.put("forceResubmit", Boolean.valueOf(translationRequest.isForceResubmission()));
        customData.put("excludedPathCount", Integer.valueOf(translationRequest.getExcludedPaths() == null ? 0 : translationRequest.getExcludedPaths().length));
        CreateLogRecordCommandPTO logRecordCommandPTO = this.getCreateLogRecordCommandBuilder().actionType(ActionTypes.START_SMARTLING_WORKFLOW.name()).description("Smartling workflow is started.").targetLocaleIds(Arrays.stream(translationRequest.getTargetLocaleCodes()).collect(Collectors.toList())).translationJobAuthorize(Boolean.valueOf(translationRequest.isAuthJob())).translationJobDueDate(translationRequest.getDueDate() == null ? null : translationRequest.getDueDate().toInstant()).translationJobName(translationRequest.getJobName()).translationJobUid(translationRequest.getJobUid()).clientUserId(translationRequest.getUserId()).sourceLocaleId(translationRequest.getSourceLocaleCode()).clientData(customData).fileUri(translationRequest.getPaths()[0]).build();
        this.sendProjectLevelLog(logRecordCommandPTO);
    }

    private CreateLogRecordCommandPTO.CreateLogRecordCommandPTOBuilder getCreateLogRecordCommandBuilder() {
        return CreateLogRecordCommandPTO.builder().actionTime(Instant.now()).envId(this.getHostName());
    }

    private void sendProjectLevelLog(CreateLogRecordCommandPTO commandPTO) {
        try {
            LOGGER.debug("Sending audit log message for actionType=\"{}\", targetLocaleIds=\"{}\".", (Object)commandPTO.getActionType(), (Object)String.join((CharSequence)", ", commandPTO.getTargetLocaleIds()));
            this.auditLogApi.createProjectLevelLogRecord(this.projectUid, commandPTO);
        }
        catch (Exception e) {
            LOGGER.error("Failed to send audit log message, actionType=\"{}\".", (Object)commandPTO.getActionType(), (Object)e);
        }
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (SecurityException | UnknownHostException e) {
            return "unknown" + this.hashCode();
        }
    }
}

