/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform.files;

import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.AuthenticationException;
import com.smartling.aem.connector.core.impl.integration.NotFoundException;
import com.smartling.aem.connector.core.impl.integration.platform.FileApiClient;
import com.smartling.api.files.v2.FilesApi;
import com.smartling.api.files.v2.exceptions.FileNotFoundException;
import com.smartling.api.files.v2.pto.DeleteFilePTO;
import com.smartling.api.files.v2.pto.DownloadTranslationPTO;
import com.smartling.api.files.v2.pto.FileItemPTO;
import com.smartling.api.files.v2.pto.FileLocaleStatusResponse;
import com.smartling.api.files.v2.pto.GetFilesListPTO;
import com.smartling.api.files.v2.pto.RetrievalType;
import com.smartling.api.v2.client.exception.RestApiRuntimeException;
import com.smartling.api.v2.client.exception.client.AuthenticationErrorException;
import com.smartling.api.v2.client.exception.client.NotFoundErrorException;
import com.smartling.api.v2.client.exception.server.MaintanenceModeErrorException;
import com.smartling.api.v2.response.ListResponse;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileApiV2Client
implements FileApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileApiV2Client.class);
    public static final String FILE_NOT_FOUND_ERROR_CODE = "file.not.found";
    private final FilesApi filesApi;

    FileApiV2Client(FilesApi filesApi) {
        this.filesApi = Objects.requireNonNull(filesApi);
    }

    @Override
    public FileLocaleStatusResponse getFileStatus(String projectUid, String fileUri, String languageCode) throws SmartlingException {
        try {
            return this.filesApi.getFileLocaleStatus(projectUid, languageCode, fileUri);
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException("Failed get status of fileUri=\"" + fileUri + "\" for locale=\"" + languageCode + "\" projectUid=\"" + projectUid + "\".", e);
        }
    }

    @Override
    public InputStream getFile(String projectUid, String fileUri, String languageCode, RetrievalType retrievalType) throws SmartlingException {
        try {
            return this.filesApi.downloadTranslatedFile(projectUid, languageCode, DownloadTranslationPTO.builder().fileUri(fileUri).retrievalType(retrievalType).build());
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException("Failed load fileUri=\"" + fileUri + "\" for locale=\"" + languageCode + "\" projectUid=\"" + projectUid + "\".", e);
        }
    }

    @Override
    public void deleteFile(String projectUid, String fileUri) throws SmartlingException {
        try {
            this.filesApi.deleteFile(projectUid, new DeleteFilePTO(fileUri));
        }
        catch (FileNotFoundException e) {
            LOGGER.info("File fileUri=\"{}\" has been already deleted or never uploaded, projectUid=\"{}\":", new Object[]{fileUri, projectUid, e});
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException("Failed to delete fileUri=\"" + fileUri + "\" projectUid=\"" + projectUid + "\".", e);
        }
    }

    @Override
    public Collection<String> getFilesList(String projectUid) throws SmartlingException {
        GetFilesListPTO getFilesListPTO = GetFilesListPTO.builder().build();
        try {
            ListResponse filesList = this.filesApi.getFilesList(projectUid, getFilesListPTO);
            return filesList.getItems().stream().map(FileItemPTO::getFileUri).collect(Collectors.toList());
        }
        catch (AuthenticationErrorException e) {
            throw new AuthenticationException("Wrong credentials", e);
        }
        catch (NotFoundErrorException e) {
            throw new NotFoundException("Couldn't find project for the request", e);
        }
        catch (MaintanenceModeErrorException e) {
            throw new SmartlingException("There is maintenance at the moment. Please try again later", e);
        }
        catch (RestApiRuntimeException e) {
            LOGGER.warn("Got error while requesting files list:", (Throwable)e);
            throw new SmartlingException(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws Exception {
        this.filesApi.close();
    }
}

