/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform.filetranslations;

import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.FileTranslationsApiClient;
import com.smartling.api.filetranslations.v2.FileTranslationsApi;
import com.smartling.api.filetranslations.v2.pto.file.FileUploadPTO;
import com.smartling.api.filetranslations.v2.pto.file.FileUploadResponse;
import com.smartling.api.filetranslations.v2.pto.mt.MtRequest;
import com.smartling.api.filetranslations.v2.pto.mt.MtResponse;
import com.smartling.api.filetranslations.v2.pto.mt.MtStatusResponse;
import com.smartling.api.v2.client.exception.RestApiRuntimeException;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileTranslationsApiV2Client
implements FileTranslationsApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTranslationsApiV2Client.class);
    private final FileTranslationsApi fileTranslationsApi;

    FileTranslationsApiV2Client(FileTranslationsApi fileTranslationsApi) {
        this.fileTranslationsApi = Objects.requireNonNull(fileTranslationsApi);
    }

    @Override
    public FileUploadResponse uploadFile(String accountUid, FileUploadPTO fileUploadPTO) throws SmartlingException {
        try {
            return this.fileTranslationsApi.uploadFile(accountUid, fileUploadPTO);
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException("Failed to upload file to accountUid=\"" + accountUid + "\".", e);
        }
    }

    @Override
    public MtResponse mtFile(String accountId, String fileUid, MtRequest mtRequest) throws SmartlingException {
        try {
            return this.fileTranslationsApi.mtFile(accountId, fileUid, mtRequest);
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException("Failed to initiate MT for fileUid=\"" + fileUid + "\" accountId=\"" + accountId + "\".", e);
        }
    }

    @Override
    public MtStatusResponse getMtProgress(String accountUid, String fileUid, String mtUid) throws SmartlingException {
        try {
            return this.fileTranslationsApi.getMtProgress(accountUid, fileUid, mtUid);
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException("Failed to get MT progress for fileUid=\"" + fileUid + "\" mtUid=\"" + mtUid + "\" accountUid=\"" + accountUid + "\".", e);
        }
    }

    @Override
    public InputStream downloadTranslatedFile(String accountUid, String fileUid, String mtUid, String localeId) throws SmartlingException {
        try {
            return this.fileTranslationsApi.downloadTranslatedFile(accountUid, fileUid, mtUid, localeId);
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException("Failed to download translated file fileUid=\"" + fileUid + "\" for locale=\"" + localeId + "\" mtUid=\"" + mtUid + "\" accountUid=\"" + accountUid + "\".", e);
        }
    }

    @Override
    public void cancelMt(String accountUid, String fileUid, String mtUid) throws SmartlingException {
        try {
            this.fileTranslationsApi.cancelMt(accountUid, fileUid, mtUid);
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException("Failed to cancel MT for fileUid=\"" + fileUid + "\" mtUid=\"" + mtUid + "\" accountUid=\"" + accountUid + "\".", e);
        }
    }

    @Override
    public void close() throws Exception {
        this.fileTranslationsApi.close();
    }
}

