/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform.instant;

import com.smartling.aem.connector.automation.impl.workflow.LocaleWorkflow;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.aem.connector.core.impl.integration.SmartlingPlatformClient;
import com.smartling.aem.connector.core.impl.integration.TranslationCancelRequest;
import com.smartling.aem.connector.core.impl.integration.TranslationDownloadRequest;
import com.smartling.aem.connector.core.impl.integration.TranslationStatusRequest;
import com.smartling.aem.connector.core.impl.integration.TranslationUploadRequest;
import com.smartling.aem.connector.core.impl.integration.TranslationUploadResult;
import com.smartling.aem.connector.core.impl.integration.platform.FileTranslationsApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.SmartlingSupport;
import com.smartling.api.filetranslations.v2.pto.FileType;
import com.smartling.api.filetranslations.v2.pto.file.FileUploadPTO;
import com.smartling.api.filetranslations.v2.pto.file.FileUploadRequest;
import com.smartling.api.filetranslations.v2.pto.file.FileUploadResponse;
import com.smartling.api.filetranslations.v2.pto.mt.MtRequest;
import com.smartling.api.filetranslations.v2.pto.mt.MtResponse;
import com.smartling.api.filetranslations.v2.pto.mt.MtStatusResponse;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantSmartlingPlatformClient
implements SmartlingPlatformClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstantSmartlingPlatformClient.class);
    private final FileTranslationsApiClient fileTranslationsApiClient;
    private final ProjectApiClient projectApiClient;

    public InstantSmartlingPlatformClient(FileTranslationsApiClient fileTranslationsApiClient, ProjectApiClient projectApiClient) {
        this.fileTranslationsApiClient = fileTranslationsApiClient;
        this.projectApiClient = projectApiClient;
    }

    @Override
    public TranslationUploadResult sendForTranslation(TranslationUploadRequest request) throws SmartlingException {
        InputStream contentStream = request.getResource().getContentStream();
        if (contentStream == null) {
            throw new SmartlingException("Content stream is null for resource");
        }
        FileUploadPTO fileUploadPTO = new FileUploadPTO();
        fileUploadPTO.setFile(contentStream);
        FileUploadRequest fileUploadRequest = new FileUploadRequest();
        fileUploadRequest.setFileType(InstantSmartlingPlatformClient.fileTypeForMimeType(request.getResource().getMimeType(), request.getFileUri()));
        fileUploadPTO.setRequest(fileUploadRequest);
        FileUploadResponse fileUploadResponse = this.fileTranslationsApiClient.uploadFile(request.getAccountUid(), fileUploadPTO);
        String fileUid = fileUploadResponse.getFileUid();
        MtRequest mtRequest = new MtRequest();
        mtRequest.setSourceLocaleId(request.getSmartlingSourceLocaleCode());
        mtRequest.setTargetLocaleIds(Collections.singletonList(request.getSmartlingTargetLocaleCode()));
        MtResponse mtResponse = this.fileTranslationsApiClient.mtFile(request.getAccountUid(), fileUid, mtRequest);
        return TranslationUploadResult.builder().fileUid(fileUid).mtUid(mtResponse.getMtUid()).build();
    }

    @Override
    public SmartlingFacade.Status getStatus(TranslationStatusRequest request) throws SmartlingException {
        MtStatusResponse mtStatusResponse = this.fileTranslationsApiClient.getMtProgress(request.getAccountUid(), request.getFileUid(), request.getMtUid());
        switch (mtStatusResponse.getState()) {
            case FAILED: {
                return SmartlingFacade.Status.FAILED;
            }
            case COMPLETED: 
            case CANCELED: {
                return SmartlingFacade.Status.COMPLETED;
            }
            case QUEUED: {
                return SmartlingFacade.Status.NOT_AUTHORIZED;
            }
            case PROCESSING: {
                return SmartlingFacade.Status.IN_PROGRESS;
            }
        }
        LOGGER.error("Unknown state for fileUid=\"{}\", mtUid=\"{}\"", (Object)request.getFileUid(), (Object)request.getMtUid());
        return SmartlingFacade.Status.COMPLETED;
    }

    @Override
    public SmartlingFacade.Status getJobStatus(String jobId, String languageCode) throws SmartlingException {
        return SmartlingFacade.Status.IN_PROGRESS;
    }

    @Override
    public InputStream getTranslated(TranslationDownloadRequest request) throws SmartlingException {
        return this.fileTranslationsApiClient.downloadTranslatedFile(request.getAccountUid(), request.getFileUid(), request.getMtUid(), request.getSmartlingTargetLocale());
    }

    @Override
    public void delete(TranslationCancelRequest request) throws SmartlingException {
        this.fileTranslationsApiClient.cancelMt(request.getAccountUid(), request.getFileUid(), request.getMtUid());
    }

    @Override
    public String createBatch(String projectId, String jobUid, boolean authorize) {
        return "";
    }

    @Override
    public void executeBatch(String projectId, String batchUid, List<LocaleWorkflow> localeWorkflows) {
    }

    @Override
    public void close() throws Exception {
        try {
            this.projectApiClient.close();
        }
        catch (Exception e) {
            LOGGER.error("Couldn't release Project API client resources", (Throwable)e);
        }
        try {
            this.fileTranslationsApiClient.close();
        }
        catch (Exception e) {
            LOGGER.error("Couldn't release File Translation API client resources", (Throwable)e);
        }
    }

    private static FileType fileTypeForMimeType(String mimeType, String fileUri) {
        FileType fileType;
        FileType fileType2 = fileType = StringUtils.isNotBlank((CharSequence)mimeType) ? SmartlingSupport.INSTANT_FILE_TYPE_BY_MIME.get(mimeType) : null;
        if (fileType == null) {
            LOGGER.warn("There is no file type for the resource fileUri=\"{}\"", (Object)fileUri);
            return FileType.XML;
        }
        return fileType;
    }
}

