/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform.instant;

import com.smartling.aem.connector.core.SmartlingConfig;
import com.smartling.aem.connector.core.impl.integration.platform.FileTranslationsApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.FileTranslationsApiClientFactory;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClientFactory;
import com.smartling.aem.connector.core.impl.integration.platform.instant.InstantSmartlingPlatformClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={InstantSmartlingPlatformClientFactory.class})
public class InstantSmartlingPlatformClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstantSmartlingPlatformClientFactory.class);
    @Reference
    private FileTranslationsApiClientFactory fileTranslationsApiClientFactory;
    @Reference
    private ProjectApiClientFactory projectApiClientFactory;

    public InstantSmartlingPlatformClient createClient(SmartlingConfig config) {
        FileTranslationsApiClient fileTranslationsApiClient = null;
        try {
            fileTranslationsApiClient = this.fileTranslationsApiClientFactory.createClient(config);
            ProjectApiClient projectApiClient = this.projectApiClientFactory.createClient(config);
            return new InstantSmartlingPlatformClient(fileTranslationsApiClient, projectApiClient);
        }
        catch (Exception e) {
            if (fileTranslationsApiClient != null) {
                try {
                    fileTranslationsApiClient.close();
                }
                catch (Exception closeEx) {
                    LOGGER.warn("Failed to close FileTranslationsApiClient during cleanup", (Throwable)closeEx);
                }
            }
            throw e;
        }
    }
}

