/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform.workflow;

import com.smartling.aem.connector.core.impl.integration.platform.WorkflowApiClient;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.smartling.api.internal.workflows.v3.WorkflowsApi;
import net.smartling.api.internal.workflows.v3.pto.UserWorkflowFilterCommandPTO;
import net.smartling.api.internal.workflows.v3.pto.UserWorkflowPTO;
import org.apache.commons.collections4.CollectionUtils;

public class WorkflowsApiV3Client
implements WorkflowApiClient {
    private final WorkflowsApi workflowsApi;
    private final String projectId;

    public WorkflowsApiV3Client(WorkflowsApi workflowsApi, String projectId) {
        this.workflowsApi = Objects.requireNonNull(workflowsApi);
        this.projectId = Objects.requireNonNull(projectId);
    }

    @Override
    public void close() throws Exception {
        this.workflowsApi.close();
    }

    @Override
    public List<UserWorkflowPTO> getUserAllowedWorkflows(String accountUid, List<String> workflowUids) {
        UserWorkflowFilterCommandPTO userWorkflowFilterCommandPTO = new UserWorkflowFilterCommandPTO();
        userWorkflowFilterCommandPTO.setProjectId(this.projectId);
        if (CollectionUtils.isNotEmpty(workflowUids)) {
            userWorkflowFilterCommandPTO.setWorkflowUids(workflowUids.stream().map(String::valueOf).collect(Collectors.toSet()));
        }
        return this.workflowsApi.getUserAllowedWorkflows(accountUid, userWorkflowFilterCommandPTO).getItems();
    }
}

